/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class SuggestionQuery
implements SearchQuery {
    private final List<Term> _terms;
    private final Query _condition;
    private BooleanQuery query = null;

    public SuggestionQuery(List<Term> terms) {
        this(terms, null);
    }

    public SuggestionQuery(List<Term> terms, Query condition) {
        this._terms = terms;
        this._condition = condition;
    }

    public void compute(IndexReader reader) throws IOException {
        HashMap<Term, Boolean> terms = new HashMap<Term, Boolean>();
        for (Term term : this._terms) {
            terms.put(term, true);
            List<String> values = Terms.prefix(reader, term);
            for (String v : values) {
                Term t = new Term(term.field(), v);
                if (terms.containsKey(t)) continue;
                terms.put(t, false);
            }
        }
        if (terms.size() >= BooleanQuery.getMaxClauseCount()) {
            List tokeep = new ArrayList(terms.keySet()).subList(0, BooleanQuery.getMaxClauseCount() - 1);
            terms.keySet().retainAll(tokeep);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (Term t : terms.keySet()) {
            if (((Boolean)terms.get(t)).booleanValue()) {
                bq.add((Query)new BoostQuery((Query)new TermQuery(t), 2.0f), BooleanClause.Occur.SHOULD);
                continue;
            }
            bq.add((Query)new TermQuery(t), BooleanClause.Occur.SHOULD);
        }
        if (this._condition != null) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(this._condition, BooleanClause.Occur.MUST);
            builder.add((Query)bq.build(), BooleanClause.Occur.MUST);
            this.query = builder.build();
        } else {
            this.query = bq.build();
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("suggestion-query");
        xml.openElement("terms");
        for (Term t : this._terms) {
            xml.openElement("term");
            xml.attribute("field", t.field());
            xml.attribute("text", t.text());
            xml.closeElement();
        }
        xml.closeElement();
        if (this._condition != null) {
            xml.openElement("condition");
            xml.writeText(this._condition.toString());
            xml.closeElement();
        }
        xml.closeElement();
    }

    @Override
    public Query toQuery() {
        return this.query;
    }

    @Override
    public boolean isEmpty() {
        return this._terms.isEmpty();
    }

    @Override
    public Sort getSort() {
        return Sort.RELEVANCE;
    }
}

