/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSuggest.class);
    private AnalyzingInfixSuggester suggester;
    private final List<String> _resultFields = new ArrayList<String>();
    private final String _name;
    private final Index _index;
    private final boolean _useTerms;
    private final List<String> _searchFields = new ArrayList<String>();
    private String _withField = null;
    private Map<String, Float> _weights = new HashMap<String, Float>();
    private long lastBuilt = -1L;

    private AutoSuggest(String name, Index index, Directory dir, Analyzer indexAnalyzer, Analyzer searchAnalyzer, boolean useTerms, int minChars) throws IndexException {
        this._name = name;
        this._index = index;
        this._useTerms = useTerms;
        try {
            this.suggester = new AnalyzingInfixSuggester(dir, indexAnalyzer, searchAnalyzer, minChars, true, true, true);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to build autosuggest {}", (Object)this._name, (Object)ex);
            throw new IndexException("Failed to build autosuggest", (Exception)ex);
        }
    }

    public List<String> getSearchFields() {
        return this._searchFields;
    }

    public void addSearchField(String field) {
        if (field != null) {
            this._searchFields.add(field);
        }
    }

    public void addSearchFields(Collection<String> fields) {
        if (fields != null) {
            this._searchFields.addAll(fields);
        }
    }

    public void addResultField(String field) {
        if (field != null) {
            this._resultFields.add(field);
        }
    }

    public void addResultFields(Collection<String> fields) {
        if (fields != null) {
            this._resultFields.addAll(fields);
        }
    }

    public void setCriteriaField(String field) {
        if (this._useTerms && field != null) {
            throw new IllegalStateException("Illogical to use criteria for words suggestions!");
        }
        this._withField = field;
    }

    public void setWeight(String field, float weight) {
        this._weights.put(field, Float.valueOf(weight));
    }

    public void setWeights(String weights) {
        if (weights == null) {
            return;
        }
        for (String weight : weights.split(",")) {
            String[] parts = weight.split(":");
            if (parts.length != 2) continue;
            try {
                this._weights.put(parts[0], Float.valueOf(parts[1]));
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Ignoring invalid autosuggest {} weight for field {}: not a number! ({})", new Object[]{this._name, parts[0], parts[1]});
            }
        }
    }

    public long getLastBuilt() {
        return this.lastBuilt;
    }

    public boolean isCurrent(IndexManager mgr) {
        return this._index.getIndexIO().getLastTimeUsed() < this.lastBuilt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(IndexReader reader) throws IndexException {
        AnalyzingInfixSuggester analyzingInfixSuggester = this.suggester;
        synchronized (analyzingInfixSuggester) {
            try {
                boolean buildit = false;
                if (this._useTerms) {
                    for (String field : this._searchFields) {
                        BytesRef text;
                        Terms terms = MultiFields.getTerms((IndexReader)reader, (String)field);
                        if (terms == null) continue;
                        TermsEnum termsEnum = terms.iterator();
                        while ((text = termsEnum.next()) != null) {
                            this.suggester.add(text, null, 1L, null);
                            buildit = true;
                        }
                    }
                } else {
                    HashSet<String> fieldsToLoad = new HashSet<String>();
                    fieldsToLoad.addAll(this._resultFields);
                    fieldsToLoad.addAll(this._searchFields);
                    fieldsToLoad.addAll(this._weights.keySet());
                    if (this._withField != null) {
                        fieldsToLoad.add(this._withField);
                    }
                    for (LeafReaderContext ctxt : reader.leaves()) {
                        if (!this.addEntries(ctxt, fieldsToLoad)) continue;
                        buildit = true;
                    }
                }
                if (buildit) {
                    this.suggester.refresh();
                    this.lastBuilt = System.currentTimeMillis();
                }
            }
            catch (IOException | IllegalStateException ex) {
                LOGGER.error("Failed to build dictionary for autosuggest {}", (Object)this._name, (Object)ex);
            }
        }
    }

    private boolean addEntries(LeafReaderContext context, Set<String> fieldsToLoad) throws IOException {
        boolean buildit = false;
        LeafReader subReader = context.reader();
        List leaves = subReader.leaves();
        if (!(leaves == null || leaves.isEmpty() || leaves.size() <= 1 && leaves.get(0) == context)) {
            for (LeafReaderContext ctxt : leaves) {
                if (!this.addEntries(ctxt, fieldsToLoad)) continue;
                buildit = true;
            }
            return buildit;
        }
        Bits live = subReader.getLiveDocs();
        for (int i = 0; i < subReader.maxDoc(); ++i) {
            String[] with;
            if (live != null && !live.get(i)) continue;
            Document doc = subReader.document(i, fieldsToLoad);
            HashSet<BytesRef> contexts = null;
            if (this._withField != null && (with = doc.getValues(this._withField)) != null) {
                contexts = new HashSet<BytesRef>();
                for (String w : with) {
                    contexts.add(new BytesRef((CharSequence)w));
                }
            }
            float weightF = 0.0f;
            for (Map.Entry<String, Float> aweight : this._weights.entrySet()) {
                String val = doc.get(aweight.getKey());
                try {
                    weightF += aweight.getValue().floatValue() * (val == null ? 1.0f : Float.parseFloat(val));
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Failed to compute weight as field {} is not a number! ({})", (Object)aweight.getKey(), (Object)val);
                }
            }
            long weight = weightF == 0.0f ? 100L : (long)(weightF * 100.0f);
            byte[] serialized = AutoSuggest.serialize(this._resultFields, doc);
            BytesRef payload = serialized == null ? null : new BytesRef(serialized);
            for (String field : this._searchFields) {
                String[] texts = doc.getValues(field);
                if (texts != null) {
                    for (String text : texts) {
                        try {
                            this.suggester.add(new BytesRef((CharSequence)text), contexts, weight, payload);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to add text for field {} to autosuggest {}", (Object)field, (Object)this._name);
                        }
                        buildit = true;
                    }
                    continue;
                }
                LOGGER.error("Failed to load values for field {} in autosuggest {}", (Object)field, (Object)this._name);
            }
        }
        return buildit;
    }

    private static byte[] serialize(Collection<String> fields, Document doc) {
        if (fields.isEmpty()) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String field : fields) {
            String[] values = doc.getValues(field);
            if (values == null) continue;
            result.put(field, values);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(result);
            out.close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to build payload", (Throwable)ex);
            return null;
        }
        return bos.toByteArray();
    }

    private Map<String, String[]> deserialize(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bis);
        try {
            return (Map)in.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Class not found when deserializing", ex);
        }
    }

    public List<Suggestion> suggest(String text) {
        return this.suggest(text, 10);
    }

    public List<Suggestion> suggest(String text, int nb) {
        return this.suggest(text, (Collection<String>)null, nb);
    }

    public List<Suggestion> suggest(String text, String with, int nb) {
        return this.suggest(text, with == null ? null : Collections.singleton(with), nb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Suggestion> suggest(String text, Collection<String> criteria, int nb) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (this.lastBuilt == -1L) {
            LOGGER.warn("Loading suggestions with empty suggester for autosuggest {}!", (Object)this._name);
            return suggestions;
        }
        if (this.suggester == null) {
            return suggestions;
        }
        HashSet<BytesRef> contexts = null;
        if (criteria != null && !criteria.isEmpty()) {
            if (this._useTerms) {
                throw new IllegalStateException("Illogical to use criteria for words suggestions!");
            }
            contexts = new HashSet<BytesRef>();
            for (String with : criteria) {
                contexts.add(new BytesRef((CharSequence)with));
            }
        }
        List results = null;
        AnalyzingInfixSuggester analyzingInfixSuggester = this.suggester;
        synchronized (analyzingInfixSuggester) {
            try {
                results = this.suggester.lookup((CharSequence)text, contexts, false, nb);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to lookup suggestions for autosuggest {}", (Object)this._name, (Object)ex);
            }
        }
        if (results != null) {
            for (Lookup.LookupResult result : results) {
                Suggestion suggestion = new Suggestion();
                suggestion.text = result.key.toString();
                suggestion.highlight = result.highlightKey.toString();
                suggestion.weight = result.value;
                if (result.payload != null) {
                    try {
                        suggestion.document = this.deserialize(result.payload.bytes);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Failed to deserialize suggestion payload", (Throwable)ex);
                    }
                }
                if (suggestions.contains(suggestion)) continue;
                suggestions.add(suggestion);
            }
        }
        return suggestions;
    }

    public void close() {
        try {
            this.suggester.close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close autosuggest {}", (Object)this._name, (Object)ex);
        }
    }

    public static class Suggestion {
        public String text;
        public String highlight;
        public Map<String, String[]> document;
        public long weight;

        public boolean equals(Object obj) {
            if (!(obj instanceof Suggestion)) {
                return false;
            }
            Suggestion s = (Suggestion)obj;
            return this.text.equals(s.text) && this.highlight.equals(s.highlight) && (this.document == null && s.document == null || this.document.equals(s.document));
        }

        public int hashCode() {
            return this.text.hashCode() * 3 + this.highlight.hashCode() * 11 + (this.document != null ? 17 * this.document.hashCode() : 0);
        }

        public String toString() {
            return this.text + (this.weight != 100L ? "(" + this.weight + ")" : "");
        }
    }

    public static class Builder {
        private Boolean _terms = null;
        private String _name = null;
        private Index _index = null;
        private Directory _dir = null;
        private Analyzer _indexAnalyzer = null;
        private Analyzer _searchAnalyzer = null;
        private String _criteria = null;
        private Map<String, Float> _weights = new HashMap<String, Float>();
        private int _minChars = 2;
        private Collection<String> _searchFields = new ArrayList<String>();
        private Collection<String> _resultFields = new ArrayList<String>();

        public Builder index(Index index) {
            this._index = index;
            return this;
        }

        public Builder indexAnalyzer(Analyzer analyzer) {
            this._indexAnalyzer = analyzer;
            return this;
        }

        public Builder searchAnalyzer(Analyzer analyzer) {
            this._searchAnalyzer = analyzer;
            return this;
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder useTerms(boolean terms) {
            this._terms = terms;
            return this;
        }

        public Builder directory(Directory dir) {
            this._dir = dir;
            return this;
        }

        public Builder minChars(int minChars) {
            this._minChars = minChars;
            return this;
        }

        public Builder searchFields(Collection<String> searchFields) {
            this._searchFields = searchFields;
            return this;
        }

        public Builder weights(Map<String, Float> weights) {
            if (weights != null) {
                this._weights.putAll(weights);
            }
            return this;
        }

        public Builder resultFields(Collection<String> resultFields) {
            this._resultFields = resultFields;
            return this;
        }

        public Builder criteria(String criteria) {
            this._criteria = criteria;
            return this;
        }

        public AutoSuggest build() throws IndexException {
            if (this._terms == null) {
                throw new IllegalStateException("missing terms");
            }
            if (this._name == null) {
                throw new IllegalStateException("missing name");
            }
            if (this._index == null) {
                throw new IllegalStateException("missing index");
            }
            RAMDirectory dir = this._dir == null ? new RAMDirectory() : this._dir;
            StandardAnalyzer indexAnalyzer = this._indexAnalyzer == null ? new StandardAnalyzer(CharArraySet.EMPTY_SET) : this._indexAnalyzer;
            StandardAnalyzer searchAnalyzer = this._searchAnalyzer == null ? new StandardAnalyzer(CharArraySet.EMPTY_SET) : this._searchAnalyzer;
            AutoSuggest as = new AutoSuggest(this._name, this._index, (Directory)dir, (Analyzer)indexAnalyzer, (Analyzer)searchAnalyzer, this._terms, this._minChars);
            as.setCriteriaField(this._criteria);
            as.addSearchFields(this._searchFields);
            as.addResultFields(this._resultFields);
            for (Map.Entry<String, Float> w : this._weights.entrySet()) {
                as.setWeight(w.getKey(), w.getValue().floatValue());
            }
            return as;
        }
    }
}

