/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.TermFilter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class DateTermFilter
extends TermFilter<OffsetDateTime>
implements Filter {
    private final DateTools.Resolution _resolution;

    private DateTermFilter(Builder builder) {
        super(builder._name, builder._dates);
        this._resolution = builder._resolution;
    }

    public DateTools.Resolution getResolution() {
        return this._resolution;
    }

    @Override
    public Query filterQuery(Query base) {
        if (this._terms.values().contains(BooleanClause.Occur.SHOULD)) {
            BooleanQuery filterQuery = new BooleanQuery();
            for (OffsetDateTime date : this._terms.keySet()) {
                filterQuery.add(new DateParameter(this._name, date, this._resolution, false).toQuery(), (BooleanClause.Occur)this._terms.get(date));
            }
            return base == null ? filterQuery : Queries.and(new Query[]{base, filterQuery});
        }
        BooleanQuery filterQuery = new BooleanQuery();
        if (base != null) {
            filterQuery.add(base, BooleanClause.Occur.MUST);
        }
        for (OffsetDateTime date : this._terms.keySet()) {
            filterQuery.add(new DateParameter(this._name, date, this._resolution, false).toQuery(), (BooleanClause.Occur)this._terms.get(date));
        }
        return filterQuery;
    }

    @Override
    public String name() {
        return this._name;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        xml.attribute("type", "date");
        for (OffsetDateTime date : this._terms.keySet()) {
            xml.openElement("term");
            xml.attribute("text", date == null ? "" : Dates.toString(date, this._resolution));
            xml.attribute("date", date == null ? "" : Dates.format(date, this._resolution));
            xml.attribute("occur", DateTermFilter.occurToString((BooleanClause.Occur)this._terms.get(date)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static DateTermFilter newFilterEmpty(String name, DateTools.Resolution res) {
        return DateTermFilter.newFilter(name, (OffsetDateTime)null, res, BooleanClause.Occur.MUST);
    }

    public static DateTermFilter newFilter(String name, Date date, DateTools.Resolution res) {
        return DateTermFilter.newFilter(name, date, res, BooleanClause.Occur.MUST);
    }

    public static DateTermFilter newFilter(String name, Date date, DateTools.Resolution res, BooleanClause.Occur occur) {
        return new Builder().name(name).resolution(res).addDate(date, occur).build();
    }

    public static DateTermFilter newFilter(String name, OffsetDateTime date, DateTools.Resolution res) {
        return DateTermFilter.newFilter(name, date, res, BooleanClause.Occur.MUST);
    }

    public static DateTermFilter newFilter(String name, OffsetDateTime date, DateTools.Resolution res, BooleanClause.Occur occur) {
        return new Builder().name(name).resolution(res).addDate(date, occur).build();
    }

    public static class Builder {
        private String _name = null;
        private DateTools.Resolution _resolution = null;
        private final Map<OffsetDateTime, BooleanClause.Occur> _dates = new HashMap<OffsetDateTime, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder resolution(DateTools.Resolution resolution) {
            this._resolution = resolution;
            return this;
        }

        public Builder addDate(Date date, BooleanClause.Occur when) {
            this._dates.put(date == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneOffset.UTC), when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public Builder addDate(OffsetDateTime date, BooleanClause.Occur when) {
            this._dates.put(date, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public DateTermFilter build() {
            if (this._name == null) {
                throw new IllegalStateException("name");
            }
            if (this._resolution == null) {
                throw new IllegalStateException("resolution");
            }
            if (this._dates.isEmpty()) {
                throw new IllegalStateException("no dates to filter with!");
            }
            return new DateTermFilter(this);
        }
    }
}

