/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.query.NumericRange;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public abstract class NumericIntervalFacet
extends FlexibleIntervalFacet {
    protected final Number _interval;
    protected final List<FlexibleIntervalFacet.Interval> _intervals = new ArrayList<FlexibleIntervalFacet.Interval>();

    private NumericIntervalFacet(String name, Number start, Number end, Number interval, boolean includeMin, boolean includeLastMax, int maxIntervals) {
        super(name, String.valueOf(start), String.valueOf(end), includeMin, includeLastMax, maxIntervals);
        this._interval = interval;
        if (start.equals(end) || end.equals(this.min(start, end))) {
            throw new IllegalArgumentException("start must be less than end");
        }
        Number i = start;
        while (i.equals(this.min(i, end))) {
            boolean withMax = this.increaseByInterval(i).equals(end) ? this.includeLastUpper() : !this.includeLower();
            Number max = this.increaseByInterval(i);
            this._intervals.add(FlexibleIntervalFacet.Interval.numericInterval(i, this.includeLower(), this.min(max, end), withMax));
            i = this.increaseByInterval(i);
        }
    }

    protected abstract Number increaseByInterval(Number var1);

    protected abstract Number min(Number var1, Number var2);

    @Override
    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this.name().equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            this.totalIntervals = 0;
            Bucket<FlexibleIntervalFacet.Interval> bucket = new Bucket<FlexibleIntervalFacet.Interval>(size);
            DocumentCounter counter = new DocumentCounter();
            for (FlexibleIntervalFacet.Interval i : this._intervals) {
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.intervalToQuery(i), BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                bucket.add(i, count);
                counter.reset();
                if (count <= 0) continue;
                ++this.totalIntervals;
            }
            this.bucket = bucket;
        }
    }

    protected void compute(IndexSearcher searcher, int size) throws IOException {
        this.totalIntervals = 0;
        Bucket<FlexibleIntervalFacet.Interval> bucket = new Bucket<FlexibleIntervalFacet.Interval>(size);
        DocumentCounter counter = new DocumentCounter();
        for (FlexibleIntervalFacet.Interval i : this._intervals) {
            searcher.search(this.intervalToQuery(i), (Collector)counter);
            int count = counter.getCount();
            bucket.add(i, count);
            counter.reset();
            if (count <= 0) continue;
            ++this.totalIntervals;
        }
        this.bucket = bucket;
    }

    protected abstract Query intervalToQuery(FlexibleIntervalFacet.Interval var1);

    @Override
    protected FlexibleIntervalFacet.Interval findInterval(Term t) {
        return null;
    }

    @Override
    protected Query termToQuery(Term t) {
        return null;
    }

    @Override
    public String getType() {
        return "numeric-interval";
    }

    @Override
    protected void intervalToXML(FlexibleIntervalFacet.Interval interval, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("interval");
        if (interval.getMin() != null) {
            xml.attribute("min", interval.getMin());
        }
        if (interval.getMax() != null) {
            xml.attribute("max", interval.getMax());
        }
        if (interval.getMin() != null) {
            xml.attribute("include-min", interval.includeMin() ? "true" : "false");
        }
        if (interval.getMax() != null) {
            xml.attribute("include-max", interval.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static class Builder {
        private FlintField.NumericType numeric = null;
        private boolean includeMin = true;
        private boolean includeLastMax = true;
        private Number interval = null;
        private Number start = null;
        private Number end = null;
        private String name = null;
        private int maxIntervals = -1;

        public Builder numeric(FlintField.NumericType num) {
            this.numeric = num;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder includeLastMax(boolean include) {
            this.includeLastMax = include;
            return this;
        }

        public Builder includeMin(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder maxIntervals(int max) {
            this.maxIntervals = max;
            return this;
        }

        public Builder start(Number s) {
            this.start = s;
            return this;
        }

        public Builder end(Number e) {
            this.end = e;
            return this;
        }

        public Builder intervalLength(Number i) {
            this.interval = i;
            return this;
        }

        public NumericIntervalFacet build() {
            if (this.name == null) {
                throw new IllegalStateException("Must have a field name");
            }
            if (this.start == null) {
                throw new IllegalStateException("Must have a start");
            }
            if (this.end == null) {
                throw new IllegalStateException("Must have an end");
            }
            if (this.interval == null || this.interval.intValue() <= 0) {
                throw new IllegalStateException("Must have an interval");
            }
            if (this.numeric == null) {
                throw new IllegalStateException("Must have a numeric type");
            }
            switch (this.numeric) {
                case INT: {
                    return new IntIntervalFacet(this.name, this.start.intValue(), this.end.intValue(), this.interval.intValue(), this.includeMin, this.includeLastMax, this.maxIntervals);
                }
                case DOUBLE: {
                    return new DoubleIntervalFacet(this.name, this.start.doubleValue(), this.end.doubleValue(), this.interval.doubleValue(), this.includeMin, this.includeLastMax, this.maxIntervals);
                }
                case FLOAT: {
                    return new FloatIntervalFacet(this.name, this.start.floatValue(), this.end.floatValue(), this.interval.floatValue(), this.includeMin, this.includeLastMax, this.maxIntervals);
                }
                case LONG: {
                    return new LongIntervalFacet(this.name, this.start.longValue(), this.end.longValue(), this.interval.longValue(), this.includeMin, this.includeLastMax, this.maxIntervals);
                }
            }
            return null;
        }
    }

    private static class LongIntervalFacet
    extends NumericIntervalFacet {
        public LongIntervalFacet(String name, long start, long end, long interval, boolean includeMin, boolean includeLastMax, int maxIntervals) {
            super(name, start, end, interval, includeMin, includeLastMax, maxIntervals);
        }

        @Override
        protected Query intervalToQuery(FlexibleIntervalFacet.Interval i) {
            return NumericRange.newLongRange(this.name(), i.getMin() == null ? null : Long.valueOf(Long.parseLong(i.getMin())), i.getMax() == null ? null : Long.valueOf(Long.parseLong(i.getMax())), i.includeMin(), i.includeMax()).toQuery();
        }

        @Override
        protected Number increaseByInterval(Number toIncrease) {
            return toIncrease.longValue() + this._interval.longValue();
        }

        @Override
        protected Number min(Number first, Number second) {
            return Math.min(first.longValue(), second.longValue());
        }
    }

    private static class DoubleIntervalFacet
    extends NumericIntervalFacet {
        public DoubleIntervalFacet(String name, double start, double end, double interval, boolean includeMin, boolean includeLastMax, int maxIntervals) {
            super(name, start, end, interval, includeMin, includeLastMax, maxIntervals);
        }

        @Override
        protected Query intervalToQuery(FlexibleIntervalFacet.Interval i) {
            return NumericRange.newDoubleRange(this.name(), i.getMin() == null ? null : Double.valueOf(Double.parseDouble(i.getMin())), i.getMax() == null ? null : Double.valueOf(Double.parseDouble(i.getMax())), i.includeMin(), i.includeMax()).toQuery();
        }

        @Override
        protected Number increaseByInterval(Number toIncrease) {
            return toIncrease.doubleValue() + this._interval.doubleValue();
        }

        @Override
        protected Number min(Number first, Number second) {
            return Math.min(first.doubleValue(), second.doubleValue());
        }
    }

    private static class FloatIntervalFacet
    extends NumericIntervalFacet {
        public FloatIntervalFacet(String name, float start, float end, float interval, boolean includeMin, boolean includeLastMax, int maxIntervals) {
            super(name, Float.valueOf(start), Float.valueOf(end), Float.valueOf(interval), includeMin, includeLastMax, maxIntervals);
        }

        @Override
        protected Query intervalToQuery(FlexibleIntervalFacet.Interval i) {
            return NumericRange.newFloatRange(this.name(), i.getMin() == null ? null : Float.valueOf(Float.parseFloat(i.getMin())), i.getMax() == null ? null : Float.valueOf(Float.parseFloat(i.getMax())), i.includeMin(), i.includeMax()).toQuery();
        }

        @Override
        protected Number increaseByInterval(Number toIncrease) {
            return Float.valueOf(toIncrease.floatValue() + this._interval.floatValue());
        }

        @Override
        protected Number min(Number first, Number second) {
            return Float.valueOf(Math.min(first.floatValue(), second.floatValue()));
        }
    }

    private static class IntIntervalFacet
    extends NumericIntervalFacet {
        public IntIntervalFacet(String name, int start, int end, int interval, boolean includeMin, boolean includeLastMax, int maxIntervals) {
            super(name, start, end, interval, includeMin, includeLastMax, maxIntervals);
        }

        @Override
        protected Query intervalToQuery(FlexibleIntervalFacet.Interval i) {
            return NumericRange.newIntRange(this.name(), i.getMin() == null ? null : Integer.valueOf(Integer.parseInt(i.getMin())), i.getMax() == null ? null : Integer.valueOf(Integer.parseInt(i.getMax())), i.includeMin(), i.includeMax()).toQuery();
        }

        @Override
        protected Number increaseByInterval(Number toIncrease) {
            return toIncrease.intValue() + this._interval.intValue();
        }

        @Override
        protected Number min(Number first, Number second) {
            return Math.min(first.intValue(), second.intValue());
        }
    }
}

