/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PhraseParameter
implements SearchParameter {
    private final String _field;
    private final String _text;
    private final PhraseQuery _query;

    public PhraseParameter(String field, String text) throws NullPointerException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this._field = field;
        this._text = text;
        if (this.isEmpty()) {
            this._query = null;
        } else {
            this._query = new PhraseQuery();
            for (String word : text.split("\\s")) {
                this._query.add(new Term(field, word));
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this._text == null || this._text.isEmpty();
    }

    @Override
    public Query toQuery() {
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("phrase-parameter");
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.element("field", this._field);
            xml.element("text", this._text);
        }
        xml.closeElement();
    }

    public String toString() {
        return this._query.toString(this._field);
    }
}

