/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.local.LocalIndex;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.pageseeder.flint.lucene.LuceneIndexIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneLocalIndex
extends LocalIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneLocalIndex.class);
    private final Directory _directory;
    private final Analyzer _analyzer;
    private final IndexIO _io;
    private final File _contentRoot;

    public LuceneLocalIndex(File indexLocation, Analyzer analyzer, File contentLocation) {
        this(indexLocation, "lucene", analyzer, contentLocation);
    }

    public LuceneLocalIndex(File indexLocation, String catalog, Analyzer analyzer, File contentLocation) {
        super(indexLocation.getName(), catalog);
        LuceneIndexIO io;
        this._directory = LuceneLocalIndex.ensureFolderExists(indexLocation);
        this._analyzer = analyzer;
        try {
            io = new LuceneIndexIO(this._directory, this._analyzer);
        }
        catch (IndexException ex) {
            ex.printStackTrace();
            io = null;
        }
        this._io = io;
        this._contentRoot = contentLocation;
    }

    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    public final Directory getIndexDirectory() {
        return this._directory;
    }

    public IndexIO getIndexIO() {
        return this._io;
    }

    public DeleteRule getDeleteRule(File file) {
        return new LuceneDeleteRule("_src", file.getAbsolutePath());
    }

    public File getContentLocation() {
        return this._contentRoot;
    }

    public Collection<FlintField> getFields(File file) {
        ArrayList<FlintField> fields = new ArrayList<FlintField>();
        if (file.exists()) {
            fields.add(this.buildField("_src", file.getAbsolutePath()));
            fields.add(this.buildField("_path", this.fileToPath(file)));
            fields.add(this.buildField("_lastmodified", String.valueOf(file.lastModified())));
            fields.add(this.buildField("_creator", "flint-lucene"));
        }
        return fields;
    }

    public Map<String, String> getParameters(File file) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (file.exists()) {
            params.put("_src", file.getAbsolutePath());
            params.put("_path", this.fileToPath(file));
            params.put("_lastmodified", String.valueOf(file.lastModified()));
            params.put("_filename", file.getName());
        }
        return params;
    }

    public String fileToPath(File f) {
        try {
            String rootPath = this._contentRoot.getCanonicalPath();
            String thisPath = f.getCanonicalPath();
            if (thisPath.startsWith(rootPath)) {
                String p = thisPath.substring(rootPath.length()).replace('\\', '/');
                return p.isEmpty() || p.charAt(0) != '/' ? '/' + p : p;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to compute file relative path", (Throwable)ex);
        }
        return f.getAbsolutePath();
    }

    public File pathToFile(String path) {
        return new File(this._contentRoot, path);
    }

    public static boolean exists(File location) {
        if (!location.exists() || !location.isDirectory()) {
            return false;
        }
        boolean exists = false;
        try {
            FSDirectory directory = FSDirectory.open((Path)location.toPath());
            exists = DirectoryReader.indexExists((Directory)directory);
            directory.close();
        }
        catch (IOException ex) {
            LOGGER.error("Unable to check if local index exists", (Throwable)ex);
        }
        return exists;
    }

    private static Directory ensureFolderExists(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
            if (!folder.exists()) {
                LOGGER.warn("Unable to create location {}", (Object)folder);
            }
        }
        try {
            return FSDirectory.open((Path)folder.toPath());
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to return a directory on local index " + folder.getName(), ex);
        }
    }

    private FlintField buildField(String name, String value) {
        return new FlintField(this.getCatalog()).store(true).tokenize(false).name(name).value(value);
    }
}

