/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Facet;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class FieldFacet
implements XMLWritable,
Facet {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    private final String _name;
    private final List<TermQuery> _queries;
    private transient Bucket<Term> _bucket;

    private FieldFacet(String name, List<TermQuery> queries) {
        this._name = name;
        this._queries = queries;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public Query forValue(String value) {
        if (value == null) {
            return null;
        }
        for (TermQuery t : this._queries) {
            if (!value.equals(t.getTerm().text())) continue;
            return t;
        }
        return new TermQuery(new Term(this._name, value));
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            Bucket<Term> bucket = new Bucket<Term>(size);
            DocumentCounter counter = new DocumentCounter();
            for (TermQuery q : this._queries) {
                BooleanQuery query = new BooleanQuery();
                query.add(base, BooleanClause.Occur.MUST);
                query.add((Query)q, BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                bucket.add(q.getTerm(), counter.getCount());
                counter.reset();
            }
            this._bucket = bucket;
        }
    }

    @Override
    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base);
    }

    @Override
    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, 10);
    }

    private void compute(IndexSearcher searcher, int size) throws IOException {
        Bucket<Term> bucket = new Bucket<Term>(size);
        DocumentCounter counter = new DocumentCounter();
        for (TermQuery q : this._queries) {
            searcher.search((Query)q, (Collector)counter);
            bucket.add(q.getTerm(), counter.getCount());
            counter.reset();
        }
        this._bucket = bucket;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("type", "field");
        xml.attribute("computed", Boolean.toString(this._bucket != null));
        if (this._bucket != null) {
            xml.attribute("total", this._bucket.getConsidered());
            for (Bucket.Entry<Term> e : this._bucket.entrySet()) {
                xml.openElement("term");
                xml.attribute("field", e.item().field());
                xml.attribute("text", e.item().text());
                xml.attribute("cardinality", e.count());
                xml.closeElement();
            }
        }
        xml.closeElement();
    }

    public Bucket<Term> getValues() {
        return this._bucket;
    }

    public static FieldFacet newFacet(String field, IndexReader reader) throws IOException {
        List<Term> terms = Terms.terms(reader, field);
        ArrayList<TermQuery> subs = new ArrayList<TermQuery>(terms.size());
        for (Term t : terms) {
            subs.add(new TermQuery(t));
        }
        return new FieldFacet(field, subs);
    }

    public static FieldFacet newFacet(String field, IndexReader reader, int maxValues) throws IOException {
        List<Term> terms = Terms.terms(reader, field);
        if (terms.size() > maxValues) {
            return null;
        }
        ArrayList<TermQuery> subs = new ArrayList<TermQuery>(terms.size());
        for (Term t : terms) {
            subs.add(new TermQuery(t));
        }
        return new FieldFacet(field, subs);
    }
}

