/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.LuceneIndexQueries;
import org.pageseeder.flint.lucene.search.FieldFacet;
import org.pageseeder.flint.lucene.search.Terms;

public final class Facets {
    private Facets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldFacet getFacet(String field, int upTo, Query query, Index index) throws IndexException, IOException {
        FieldFacet facet = null;
        IndexReader reader = null;
        IndexSearcher searcher = null;
        try {
            reader = LuceneIndexQueries.grabReader(index);
            facet = FieldFacet.newFacet(field, reader);
            searcher = LuceneIndexQueries.grabSearcher(index);
            facet.compute(searcher, query, upTo);
        }
        catch (Throwable throwable) {
            LuceneIndexQueries.releaseQuietly(index, reader);
            LuceneIndexQueries.releaseQuietly(index, searcher);
            throw throwable;
        }
        LuceneIndexQueries.releaseQuietly(index, reader);
        LuceneIndexQueries.releaseQuietly(index, searcher);
        return facet;
    }

    public static List<FieldFacet> getFacets(List<String> fields, int upTo, Query query, Index index) throws IOException, IndexException {
        if (query == null) {
            return Facets.getFacets(fields, upTo, index);
        }
        if (fields == null || fields.isEmpty() || index == null) {
            return Collections.emptyList();
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        for (String field : fields) {
            if (field.length() <= 0) continue;
            facets.add(Facets.getFacet(field, upTo, query, index));
        }
        return facets;
    }

    public static List<FieldFacet> getFacets(int maxValues, Index index) throws IOException, IndexException {
        return Facets.getFacets(null, maxValues, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int maxValues, Index index) throws IOException, IndexException {
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        IndexReader reader = LuceneIndexQueries.grabReader(index);
        IndexSearcher searcher = LuceneIndexQueries.grabSearcher(index);
        try {
            List<String> loopfields = fields == null ? Terms.fields(reader) : fields;
            for (String field : loopfields) {
                FieldFacet facet;
                if (field.length() <= 0 || field.charAt(0) == '_' || (facet = FieldFacet.newFacet(field, reader, maxValues)) == null) continue;
                facet.compute(searcher, null, maxValues);
                facets.add(facet);
            }
        }
        finally {
            LuceneIndexQueries.releaseQuietly(index, reader);
            LuceneIndexQueries.releaseQuietly(index, searcher);
        }
        return facets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int upTo, Query query, List<Index> indexes) throws IOException, IndexException {
        if (fields == null || fields.isEmpty() || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        if (indexes.size() == 1) {
            return Facets.getFacets(fields, upTo, query, indexes.get(0));
        }
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        for (int i = 0; i < indexes.size(); ++i) {
            Index index = indexes.get(i);
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            for (String field : fields) {
                if (field.length() <= 0) continue;
                FieldFacet facet = FieldFacet.newFacet(field, (IndexReader)multiReader);
                facet.compute(multiSearcher, query, upTo);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }

    public static List<FieldFacet> getFacets(int maxValues, List<Index> indexes) throws IOException, IndexException {
        return Facets.getFacets(null, maxValues, indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldFacet> getFacets(List<String> fields, int maxValues, List<Index> indexes) throws IOException, IndexException {
        HashMap<Index, IndexReader> readers = new HashMap<Index, IndexReader>();
        for (int i = 0; i < indexes.size(); ++i) {
            Index index = indexes.get(i);
            readers.put(index, LuceneIndexQueries.grabReader(index));
        }
        ArrayList<FieldFacet> facets = new ArrayList<FieldFacet>();
        try {
            MultiReader multiReader = new MultiReader(readers.values().toArray(new IndexReader[0]));
            IndexSearcher multiSearcher = new IndexSearcher((IndexReader)multiReader);
            List<String> loopfields = fields == null ? Terms.fields((IndexReader)multiReader) : fields;
            for (String field : loopfields) {
                FieldFacet facet;
                if (field.length() <= 0 || (facet = FieldFacet.newFacet(field, (IndexReader)multiReader, maxValues)) == null) continue;
                facet.compute(multiSearcher, null, maxValues);
                facets.add(facet);
            }
        }
        finally {
            for (Map.Entry entry : readers.entrySet()) {
                LuceneIndexQueries.release((Index)entry.getKey(), (IndexReader)entry.getValue());
            }
        }
        return facets;
    }
}

