/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class TermRange
implements SearchParameter {
    private final String _field;
    private String _min;
    private String _max;
    private boolean _minInclusive;
    private boolean _maxInclusive;
    private volatile Query _query;

    private TermRange(String field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        this._field = field;
        this._min = min;
        this._max = max;
        this._maxInclusive = maxInclusive;
        this._minInclusive = minInclusive;
    }

    public String min() {
        return this._min;
    }

    public String max() {
        return this._max;
    }

    public String field() {
        return this._field;
    }

    public boolean includesMin() {
        return this._minInclusive;
    }

    public boolean includesMax() {
        return this._maxInclusive;
    }

    @Override
    public boolean isEmpty() {
        return this._min == null && this._max == null;
    }

    @Override
    public Query toQuery() {
        if (this._min == null && this._max == null) {
            return null;
        }
        if (this._query == null) {
            this._query = TermRangeQuery.newStringRange((String)this._field, (String)this._min, (String)this._max, (boolean)this._minInclusive, (boolean)this._maxInclusive);
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("term-range", false);
        xml.attribute("type", "string");
        xml.attribute("field", this._field);
        if (this._min != null) {
            xml.attribute("min", this._min);
            xml.attribute("min-included", Boolean.toString(this._minInclusive));
        }
        if (this._max != null) {
            xml.attribute("max", this._max);
            xml.attribute("max-included", Boolean.toString(this._maxInclusive));
        }
        xml.closeElement();
    }

    public static TermRange newRange(String field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return new TermRange(field, min, max, minInclusive, maxInclusive);
    }
}

