/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PredicateSearchQuery
implements SearchQuery {
    private final String _predicate;
    private final Analyzer _analyser;
    private final Sort _sort;
    private final String _defaultfield;
    private boolean _allowLeadingWildcard = false;

    public PredicateSearchQuery(String predicate, String sortField) throws IllegalArgumentException {
        this(predicate, sortField == null ? Sort.INDEXORDER : new Sort(new SortField(sortField, SortField.Type.STRING)));
    }

    public PredicateSearchQuery(String predicate, Analyzer analyzer, String sortField) throws IllegalArgumentException {
        this(predicate, analyzer, sortField == null ? Sort.INDEXORDER : new Sort(new SortField(sortField, SortField.Type.STRING)));
    }

    public PredicateSearchQuery(String predicate) throws IllegalArgumentException {
        this(predicate, Sort.INDEXORDER);
    }

    public PredicateSearchQuery(String predicate, Analyzer analyzer) throws IllegalArgumentException {
        this(predicate, analyzer, Sort.INDEXORDER);
    }

    public PredicateSearchQuery(String predicate, Sort sort) throws IllegalArgumentException {
        this(predicate, (Analyzer)new StandardAnalyzer(), sort);
    }

    public PredicateSearchQuery(String predicate, Analyzer analyzer, Sort sort) throws IllegalArgumentException {
        this(predicate, analyzer, null, sort);
    }

    public PredicateSearchQuery(String predicate, Analyzer analyzer, String defaultfield, Sort sort) throws IllegalArgumentException {
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is null");
        }
        this._predicate = predicate;
        this._analyser = analyzer;
        this._defaultfield = defaultfield;
        this._sort = sort;
    }

    public void setAllowWildCardStart(boolean allowWildCardStart) {
        this._allowLeadingWildcard = allowWildCardStart;
    }

    @Override
    public Query toQuery() {
        if (this._predicate == null) {
            return null;
        }
        try {
            QueryParser parser = new QueryParser(this._defaultfield, this._analyser);
            parser.setAllowLeadingWildcard(this._allowLeadingWildcard);
            return parser.parse(this._predicate);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this._predicate == null;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("search-query", true);
        xml.element("predicate", this._predicate);
        xml.closeElement();
    }

    @Override
    public Sort getSort() {
        return this._sort;
    }

    public String toString() {
        return this._predicate;
    }
}

