/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.lucene.LuceneIndexQueries;

public final class MultipleIndexReader {
    private final Map<Index, IndexReader> _indexes = new HashMap<Index, IndexReader>();

    protected MultipleIndexReader(List<Index> indexes) {
        for (Index index : indexes) {
            this._indexes.put(index, null);
        }
    }

    public IndexReader grab() throws IndexException {
        IndexReader[] readers = new IndexReader[this._indexes.size()];
        int i = 0;
        for (Index index : this._indexes.keySet()) {
            IndexReader reader = LuceneIndexQueries.grabReader(index);
            readers[i++] = reader;
            this._indexes.put(index, reader);
        }
        try {
            return new MultiReader(readers);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to load multiple index reader", (Exception)ex);
        }
    }

    public void releaseSilently() {
        while (!this._indexes.isEmpty()) {
            Index index = this._indexes.keySet().iterator().next();
            IndexReader reader = this._indexes.remove(index);
            LuceneIndexQueries.releaseQuietly(index, reader);
        }
    }
}

