/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public abstract class FlexibleFieldFacet
implements XMLWritable {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    private final String _name;
    private final int _maxTerms;
    private transient Bucket<String> _bucket;
    private transient boolean flexible = false;
    private transient int totalTerms = -1;
    private transient boolean hasResults = false;

    protected FlexibleFieldFacet(String name, int maxterms) {
        this._name = name;
        this._maxTerms = maxterms;
    }

    public String name() {
        return this._name;
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.totalTerms = size == 0 ? -1 : 0;
            this.hasResults = false;
            this._bucket = null;
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this._name.equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            if (size == 0) {
                try {
                    BooleanQuery query = new BooleanQuery();
                    query.add(filtered, BooleanClause.Occur.MUST);
                    query.add((Query)new WildcardQuery(new Term(this._name, "*")), BooleanClause.Occur.MUST);
                    TopDocs td = searcher.search((Query)query, 1);
                    this.hasResults = td.totalHits > 0;
                    return;
                }
                catch (Exception query) {
                    // empty catch block
                }
            }
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this.name());
            if (this._maxTerms > 0 && terms.size() > this._maxTerms) {
                return;
            }
            DocumentCounter counter = new DocumentCounter();
            Bucket<String> bucket = new Bucket<String>(size);
            for (Term t : terms) {
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.termToQuery(t), BooleanClause.Occur.MUST);
                if (size == 0) {
                    TopDocs td = searcher.search((Query)query, 1);
                    if (td.totalHits <= 0) continue;
                    this.hasResults = true;
                    return;
                }
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                bucket.add(t.text(), count);
                counter.reset();
                if (count <= 0) continue;
                ++this.totalTerms;
            }
            if (size != 0) {
                this._bucket = bucket;
            }
        }
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        this.compute(searcher, base, null, size);
    }

    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, null, 10);
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base, filters, 10);
    }

    private void compute(IndexSearcher searcher, int size) throws IOException {
        if (size == 0) {
            this.totalTerms = -1;
            this._bucket = null;
            this.hasResults = !Terms.terms(searcher.getIndexReader(), this._name).isEmpty();
        } else {
            this.totalTerms = size == 0 ? -1 : 0;
            this.hasResults = false;
            this._bucket = null;
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
            if (this._maxTerms > 0 && terms.size() > this._maxTerms) {
                return;
            }
            Bucket<String> bucket = new Bucket<String>(size);
            DocumentCounter counter = new DocumentCounter();
            for (Term t : terms) {
                searcher.search(this.termToQuery(t), (Collector)counter);
                bucket.add(t.text(), counter.getCount());
                counter.reset();
                ++this.totalTerms;
            }
            this._bucket = bucket;
        }
    }

    protected abstract Query termToQuery(Term var1);

    protected abstract String getType();

    protected abstract void termToXML(String var1, int var2, XMLWriter var3) throws IOException;

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("type", this.getType());
        xml.attribute("flexible", String.valueOf(this.flexible));
        if (this.totalTerms == -1) {
            xml.attribute("has-results", this.hasResults ? "true" : "false");
        } else {
            xml.attribute("has-results", this.totalTerms > 0 ? "true" : "false");
            xml.attribute("total-terms", this.totalTerms);
        }
        if (this._bucket != null) {
            for (Bucket.Entry<String> e : this._bucket.entrySet()) {
                this.termToXML(e.item(), e.count(), xml);
            }
        }
        xml.closeElement();
    }

    public Bucket<String> getValues() {
        return this._bucket;
    }

    public int getTotalTerms() {
        return this.totalTerms;
    }

    public boolean hasResults() {
        return this.hasResults;
    }
}

