/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.pageseeder.flint.lucene.search.FieldDocumentChecker;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Terms {
    private static final Logger LOGGER = LoggerFactory.getLogger(Terms.class);
    private static final Comparator<Term> TEXT_COMPARATOR = new Comparator<Term>(){

        @Override
        public int compare(Term t1, Term t2) {
            return t1.text().compareTo(t2.text());
        }
    };

    private Terms() {
    }

    public static Comparator<Term> textComparator() {
        return TEXT_COMPARATOR;
    }

    public static List<Term> terms(List<String> fields, List<String> texts) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String field : fields) {
            for (String text : texts) {
                terms.add(new Term(field, text));
            }
        }
        return terms;
    }

    public static List<String> fuzzy(IndexReader reader, Term term) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        Terms.fuzzy(reader, values, term);
        return values;
    }

    public static List<String> prefix(IndexReader reader, Term term) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        Terms.prefix(reader, terms, term);
        return terms;
    }

    public static void fuzzy(IndexReader reader, List<String> values, Term term) throws IOException {
        Terms.fuzzy(reader, values, term, 2);
    }

    public static void fuzzy(IndexReader reader, List<String> values, Term term, int minSimilarity) throws IOException {
        BytesRef val;
        org.apache.lucene.index.Terms terms;
        AttributeSource atts = new AttributeSource();
        Fields fields = MultiFields.getFields((IndexReader)reader);
        org.apache.lucene.index.Terms terms2 = terms = fields == null ? null : fields.terms(term.field());
        if (terms == null) {
            return;
        }
        FuzzyTermsEnum fuzzy = new FuzzyTermsEnum(terms, atts, term, 2.0f, 0, true);
        BytesRef searched = term.bytes();
        while ((val = fuzzy.next()) != null) {
            if (searched.bytesEquals(val)) continue;
            values.add(val.utf8ToString());
        }
    }

    @Beta
    public static void fuzzy(IndexReader reader, Bucket<Term> bucket, Term term) throws IOException {
        Terms.fuzzy(reader, bucket, term, 2);
    }

    @Beta
    public static void fuzzy(IndexReader reader, Bucket<Term> bucket, Term term, int minSimilarity) throws IOException {
        BytesRef val;
        org.apache.lucene.index.Terms terms;
        AttributeSource atts = new AttributeSource();
        Fields fields = MultiFields.getFields((IndexReader)reader);
        org.apache.lucene.index.Terms terms2 = terms = fields == null ? null : fields.terms(term.field());
        if (terms == null) {
            return;
        }
        FuzzyTermsEnum fuzzy = new FuzzyTermsEnum(terms, atts, term, (float)minSimilarity, 0, true);
        BytesRef searched = term.bytes();
        while ((val = fuzzy.next()) != null) {
            if (searched.bytesEquals(val)) continue;
            Term t = new Term(term.field(), BytesRef.deepCopyOf((BytesRef)val));
            bucket.add(t, reader.docFreq(t));
        }
    }

    public static void prefix(IndexReader reader, List<String> values, Term term) throws IOException {
        BytesRef val;
        org.apache.lucene.index.Terms terms;
        Fields fields = MultiFields.getFields((IndexReader)reader);
        org.apache.lucene.index.Terms terms2 = terms = fields == null ? null : fields.terms(term.field());
        if (terms == null) {
            return;
        }
        TermsEnum prefixes = terms.intersect(new CompiledAutomaton(PrefixQuery.toAutomaton((BytesRef)term.bytes())), term.bytes());
        while ((val = prefixes.next()) != null) {
            values.add(val.utf8ToString());
        }
    }

    public static void prefix(IndexReader reader, Bucket<Term> bucket, Term term) throws IOException {
        BytesRef val;
        org.apache.lucene.index.Terms terms;
        Fields fields = MultiFields.getFields((IndexReader)reader);
        org.apache.lucene.index.Terms terms2 = terms = fields == null ? null : fields.terms(term.field());
        if (terms == null) {
            return;
        }
        TermsEnum prefixes = terms.intersect(new CompiledAutomaton(PrefixQuery.toAutomaton((BytesRef)term.bytes())), term.bytes());
        while ((val = prefixes.next()) != null) {
            Term t = new Term(term.field(), BytesRef.deepCopyOf((BytesRef)val));
            bucket.add(t, reader.docFreq(t));
        }
    }

    @Beta
    public static List<String> fields(IndexReader reader) throws IOException {
        LOGGER.debug("Loading fields");
        ArrayList<String> fieldnames = new ArrayList<String>();
        Fields fields = MultiFields.getFields((IndexReader)reader);
        if (fields == null) {
            return fieldnames;
        }
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            fieldnames.add((String)it.next());
        }
        return fieldnames;
    }

    @Beta
    public static List<Term> terms(IndexReader reader, String field) throws IOException {
        BytesRef t;
        LOGGER.debug("Loading terms for field {}", (Object)field);
        org.apache.lucene.index.Terms terms = MultiFields.getTerms((IndexReader)reader, (String)field);
        if (terms == null) {
            return Collections.emptyList();
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum == TermsEnum.EMPTY) {
            return Collections.emptyList();
        }
        HashMap<BytesRef, Term> termsList = new HashMap<BytesRef, Term>();
        while (termsEnum.next() != null && (t = termsEnum.term()) != null) {
            termsList.put(t, new Term(field, BytesRef.deepCopyOf((BytesRef)t)));
        }
        return new ArrayList<Term>(termsList.values());
    }

    @Beta
    public static List<String> fields(IndexSearcher searcher, Query query, List<String> candidates) throws IOException {
        LOGGER.debug("Loading fields for query {}", (Object)query);
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : candidates) {
            FieldDocumentChecker checker = new FieldDocumentChecker(field);
            searcher.search(query, (Collector)checker);
            if (!checker.fieldFound()) continue;
            fields.add(field);
        }
        return fields;
    }

    @Beta
    public static List<String> values(IndexReader reader, String field) throws IOException {
        BytesRef t;
        LOGGER.debug("Loading term values for field {}", (Object)field);
        ArrayList<String> values = new ArrayList<String>();
        org.apache.lucene.index.Terms terms = MultiFields.getTerms((IndexReader)reader, (String)field);
        if (terms == null) {
            return values;
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum == TermsEnum.EMPTY) {
            return values;
        }
        while (termsEnum.next() != null && (t = termsEnum.term()) != null) {
            values.add(t.utf8ToString());
        }
        return values;
    }

    public static void toXML(XMLWriter xml, List<Term> terms) throws IOException {
        for (Term t : terms) {
            Terms.toXML(xml, t);
        }
    }

    public static void toXML(XMLWriter xml, Bucket<Term> terms) throws IOException {
        for (Bucket.Entry<Term> t : terms.entrySet()) {
            Terms.toXML(xml, t.item(), t.count());
        }
    }

    public static void toXML(XMLWriter xml, Term t) throws IOException {
        xml.openElement("term");
        xml.attribute("field", t.field());
        xml.attribute("text", t.text());
        xml.closeElement();
    }

    public static void toXML(XMLWriter xml, Term t, int frequency) throws IOException {
        xml.openElement("term");
        xml.attribute("field", t.field());
        xml.attribute("text", t.text());
        xml.attribute("frequency", frequency);
        xml.closeElement();
    }
}

