/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class DateTermFilter
implements Filter {
    private final String _name;
    private final DateTools.Resolution _resolution;
    private final Map<OffsetDateTime, BooleanClause.Occur> _dates = new HashMap<OffsetDateTime, BooleanClause.Occur>();

    private DateTermFilter(Builder builder) {
        this._name = builder._name;
        this._resolution = builder._resolution;
        this._dates.putAll(builder._dates);
    }

    @Override
    public Query filterQuery(Query base) {
        BooleanQuery filterQuery = new BooleanQuery();
        for (OffsetDateTime date : this._dates.keySet()) {
            BooleanClause.Occur clause = this._dates.get(date);
            filterQuery.add(new DateParameter(this._name, date, this._resolution, false).toQuery(), clause);
        }
        return base == null ? filterQuery : Queries.and(new Query[]{base, filterQuery});
    }

    @Override
    public String name() {
        return this._name;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        for (OffsetDateTime date : this._dates.keySet()) {
            xml.openElement("term");
            xml.attribute("text", Dates.toString(date, this._resolution));
            xml.attribute("date", Dates.format(date, this._resolution));
            xml.attribute("occur", DateTermFilter.occurToString(this._dates.get(date)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static DateTermFilter newFilter(String name, Date date, DateTools.Resolution res) {
        return DateTermFilter.newFilter(name, date, res, BooleanClause.Occur.MUST);
    }

    public static DateTermFilter newFilter(String name, Date date, DateTools.Resolution res, BooleanClause.Occur occur) {
        return new Builder().name(name).resolution(res).addDate(date, occur).build();
    }

    public static DateTermFilter newFilter(String name, OffsetDateTime date, DateTools.Resolution res) {
        return DateTermFilter.newFilter(name, date, res, BooleanClause.Occur.MUST);
    }

    public static DateTermFilter newFilter(String name, OffsetDateTime date, DateTools.Resolution res, BooleanClause.Occur occur) {
        return new Builder().name(name).resolution(res).addDate(date, occur).build();
    }

    private static String occurToString(BooleanClause.Occur occur) {
        if (occur == BooleanClause.Occur.MUST) {
            return "must";
        }
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return "must_not";
        }
        if (occur == BooleanClause.Occur.SHOULD) {
            return "should";
        }
        return "unknown";
    }

    public static class Builder {
        private String _name = null;
        private DateTools.Resolution _resolution = null;
        private final Map<OffsetDateTime, BooleanClause.Occur> _dates = new HashMap<OffsetDateTime, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder resolution(DateTools.Resolution resolution) {
            this._resolution = resolution;
            return this;
        }

        public Builder addDate(Date date, BooleanClause.Occur when) {
            if (date != null) {
                this._dates.put(OffsetDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneOffset.UTC), when == null ? BooleanClause.Occur.MUST : when);
            }
            return this;
        }

        public Builder addDate(OffsetDateTime date, BooleanClause.Occur when) {
            this._dates.put(date, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public DateTermFilter build() {
            if (this._name == null) {
                throw new NullPointerException("name");
            }
            if (this._resolution == null) {
                throw new NullPointerException("resolution");
            }
            if (this._dates.isEmpty()) {
                throw new IllegalStateException("no dates to filter with!");
            }
            return new DateTermFilter(this);
        }
    }
}

