/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public abstract class FlexibleRangeFacet
implements XMLWritable {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    private final String _name;
    protected transient Bucket<Range> _bucket;
    protected transient boolean flexible = false;
    protected transient int totalRanges = 0;
    protected static final Range OTHER = new Range(null, false, null, false);

    protected FlexibleRangeFacet(String name) {
        this._name = name;
    }

    public String name() {
        return this._name;
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.totalRanges = 0;
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this._name.equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            DocumentCounter counter = new DocumentCounter();
            HashMap<Range, Integer> ranges = new HashMap<Range, Integer>();
            for (Term t : terms) {
                Range r = this.findRange(t);
                if (r == null) {
                    r = OTHER;
                }
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.termToQuery(t), BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                if (count > 0) {
                    Integer ec = (Integer)ranges.get(r);
                    ranges.put(r, count + (ec == null ? 0 : ec));
                }
                counter.reset();
            }
            this.totalRanges = ranges.size();
            Bucket<Range> b = new Bucket<Range>(size);
            for (Range r : ranges.keySet()) {
                b.add(r, (Integer)ranges.get(r));
            }
            this._bucket = b;
        }
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        this.compute(searcher, base, null, size);
    }

    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, null, 10);
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base, filters, 10);
    }

    protected void compute(IndexSearcher searcher, int size) throws IOException {
        List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
        DocumentCounter counter = new DocumentCounter();
        HashMap<Range, Integer> ranges = new HashMap<Range, Integer>();
        for (Term t : terms) {
            Range r = this.findRange(t);
            if (r == null) {
                r = OTHER;
            }
            searcher.search(this.termToQuery(t), (Collector)counter);
            int count = counter.getCount();
            if (count > 0) {
                Integer ec = (Integer)ranges.get(r);
                ranges.put(r, count + (ec == null ? 0 : ec));
            }
            counter.reset();
        }
        this.totalRanges = ranges.size();
        Bucket<Range> b = new Bucket<Range>(size);
        for (Range r : ranges.keySet()) {
            b.add(r, (Integer)ranges.get(r));
        }
        this._bucket = b;
    }

    protected Query termToQuery(Term t) {
        return new TermQuery(t);
    }

    protected abstract String getType();

    protected abstract void rangeToXML(Range var1, int var2, XMLWriter var3) throws IOException;

    protected abstract Range findRange(Term var1);

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("type", this.getType());
        xml.attribute("flexible", String.valueOf(this.flexible));
        if (!this.flexible) {
            xml.attribute("total-ranges", this.totalRanges);
        }
        if (this._bucket != null) {
            for (Bucket.Entry<Range> e : this._bucket.entrySet()) {
                if (e.item() == OTHER) {
                    xml.openElement("remaining-range");
                    xml.attribute("cardinality", e.count());
                    xml.closeElement();
                    continue;
                }
                this.rangeToXML(e.item(), e.count(), xml);
            }
        }
        xml.closeElement();
    }

    public Bucket<Range> getValues() {
        return this._bucket;
    }

    public int getTotalRanges() {
        return this.totalRanges;
    }

    public static class Range
    implements Comparable<Range> {
        private final String min;
        private final String max;
        private boolean includeMin;
        private boolean includeMax;

        private Range(String mi, boolean withMin, String ma, boolean withMax) {
            this.max = ma;
            this.min = mi;
            this.includeMin = withMin;
            this.includeMax = withMax;
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        protected boolean includeMax() {
            return this.includeMax;
        }

        protected boolean includeMin() {
            return this.includeMin;
        }

        public String toString() {
            return (this.includeMin ? (char)'[' : '{') + this.min + '-' + this.max + (this.includeMax ? (char)']' : '}');
        }

        public boolean equals(Object obj) {
            if (obj instanceof Range) {
                Range r = (Range)obj;
                return (r.min == null && this.min == null || r.min != null && r.min.equals(this.min)) && (r.max == null && this.max == null || r.max != null && r.max.equals(this.max)) && this.includeMin == r.includeMin && this.includeMax == r.includeMax;
            }
            return false;
        }

        public int hashCode() {
            return (this.min != null ? this.min.hashCode() * 13 : 13) + (this.max != null ? this.max.hashCode() * 11 : 11) + (this.includeMin ? 17 : 7) + (this.includeMax ? 5 : 3);
        }

        @Override
        public int compareTo(Range o) {
            if (this.min == null) {
                if (o.min != null) {
                    return -1;
                }
                if (this.max == null) {
                    return -1;
                }
                if (o.max == null) {
                    return 1;
                }
                return this.max.compareTo(o.max);
            }
            if (o.min == null) {
                return 1;
            }
            return this.min.compareTo(o.min);
        }

        public static Range stringRange(String mi, String ma) {
            return Range.stringRange(mi, true, ma, true);
        }

        public static Range stringRange(String mi, boolean withMin, String ma, boolean withMax) {
            return new Range(mi, true, ma, true);
        }

        public static Range numericRange(Number mi, Number ma) {
            return Range.numericRange(mi, true, ma, true);
        }

        public static Range numericRange(Number mi, boolean withMin, Number ma, boolean withMax) {
            return new Range(mi == null ? null : mi.toString(), withMin, ma == null ? null : ma.toString(), withMax);
        }

        public static Range dateRange(Date mi, Date ma, DateTools.Resolution res) {
            return Range.dateRange(mi, true, ma, true, res);
        }

        public static Range dateRange(Date mi, boolean withMin, Date ma, boolean withMax, DateTools.Resolution res) {
            return new Range(Dates.toString(mi, res), withMin, Dates.toString(ma, res), withMax);
        }
    }
}

