/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DateIntervalFacet
extends FlexibleIntervalFacet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateIntervalFacet.class);
    private final DateTools.Resolution _resolution;
    private final Period _intervalDate;
    private final Duration _intervalTime;
    private final OffsetDateTime _start;
    private final boolean _includeMin;
    private final boolean _includeMax;

    private DateIntervalFacet(String name, OffsetDateTime start, int maxIntervals, DateTools.Resolution resolution, Period p, Duration d, boolean includeMin, boolean includeMax) {
        super(name, Dates.toString(start, resolution), maxIntervals);
        this._start = start;
        this._resolution = resolution;
        this._intervalDate = p;
        this._intervalTime = d;
        this._includeMin = includeMin;
        this._includeMax = includeMax;
    }

    @Override
    protected Query termToQuery(Term t) {
        try {
            Date d = DateTools.stringToDate((String)t.text());
            return new DateParameter(this.name(), d, this._resolution, false).toQuery();
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return new TermQuery(t);
        }
    }

    @Override
    protected String getType() {
        return "date-interval";
    }

    @Override
    protected FlexibleIntervalFacet.Interval findInterval(Term t) {
        Date d;
        if (t == null) {
            return null;
        }
        try {
            d = DateTools.stringToDate((String)t.text());
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return null;
        }
        return this.findInterval(OffsetDateTime.ofInstant(Instant.ofEpochMilli(d.getTime()), ZoneId.of("GMT")));
    }

    private FlexibleIntervalFacet.Interval findInterval(OffsetDateTime date) {
        boolean lowerLimit;
        boolean forward = date.isAfter(this._start);
        OffsetDateTime from = this._start;
        do {
            boolean upperLimit;
            OffsetDateTime to;
            if (forward) {
                to = this._intervalDate == null ? from : from.plus(this._intervalDate);
                to = this._intervalTime == null ? to : to.plus(this._intervalTime);
            } else {
                to = this._intervalDate == null ? from : from.minus(this._intervalDate);
                to = this._intervalTime == null ? to : to.minus(this._intervalTime);
            }
            OffsetDateTime lower = forward ? from : to;
            OffsetDateTime upper = forward ? to : from;
            lowerLimit = date.isAfter(lower) || this._includeMin && date.equals(lower);
            boolean bl = upperLimit = date.isBefore(upper) || this._includeMax && date.equals(upper);
            if (lowerLimit && upperLimit) {
                return FlexibleIntervalFacet.Interval.dateInterval(new Date(lower.toEpochSecond() * 1000L), this._includeMin, new Date(upper.toEpochSecond() * 1000L), this._includeMax, this._resolution);
            }
            from = to;
            if (!forward || !upperLimit) continue;
            return null;
        } while (forward || !lowerLimit);
        return null;
    }

    @Override
    protected void intervalToXML(FlexibleIntervalFacet.Interval interval, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("interval");
        if (interval.getMin() != null) {
            try {
                xml.attribute("min", Dates.format(DateTools.stringToDate((String)interval.getMin()), this._resolution));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (interval.getMax() != null) {
            try {
                xml.attribute("max", Dates.format(DateTools.stringToDate((String)interval.getMax()), this._resolution));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (interval.getMin() != null) {
            xml.attribute("include-min", interval.includeMin() ? "true" : "false");
        }
        if (interval.getMax() != null) {
            xml.attribute("include-max", interval.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static class Builder {
        private OffsetDateTime start = null;
        private boolean includeMin = true;
        private boolean includeMax = false;
        private Period intervalDate = null;
        private Duration intervalTime = null;
        private DateTools.Resolution resolution = null;
        private String name = null;
        private int maxIntervals = -1;

        public Builder resolution(DateTools.Resolution res) {
            this.resolution = res;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder includeMax(boolean include) {
            this.includeMax = include;
            return this;
        }

        public Builder includeMin(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder intervalDate(Period p) {
            this.intervalDate = p;
            return this;
        }

        public Builder intervalTime(Duration d) {
            this.intervalTime = d;
            return this;
        }

        public Builder maxIntervals(int max) {
            this.maxIntervals = max;
            return this;
        }

        public Builder start(Date startDate) {
            this.start = OffsetDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.of("GMT"));
            return this;
        }

        public Builder start(OffsetDateTime startDate) {
            this.start = startDate;
            return this;
        }

        public DateIntervalFacet build() {
            if (this.name == null) {
                throw new NullPointerException("Must have a field name");
            }
            if (this.resolution == null) {
                throw new NullPointerException("Must have a resolution");
            }
            if (this.start == null) {
                throw new NullPointerException("Must have a start date");
            }
            if (this.intervalTime == null && this.intervalDate == null) {
                throw new NullPointerException("Must have a valid interval (period or duration)");
            }
            return new DateIntervalFacet(this.name, this.start, this.maxIntervals, this.resolution, this.intervalDate, this.intervalTime, this.includeMin, this.includeMax);
        }
    }
}

