/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;

public final class Queries {
    private static final Pattern IS_A_PHRASE = Pattern.compile("\\\"[^\\\"]+\\\"");

    private Queries() {
    }

    public static Query and(Query ... queries) {
        if (queries.length == 1) {
            return queries[0];
        }
        BooleanQuery query = new BooleanQuery();
        for (Query q : queries) {
            query.add(q, BooleanClause.Occur.MUST);
        }
        return query;
    }

    public static Query or(Query ... queries) {
        if (queries.length == 1) {
            return queries[0];
        }
        BooleanQuery query = new BooleanQuery();
        for (Query q : queries) {
            query.add(q, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    @Beta
    public static List<Query> similar(Query query, Collection<Term> terms, IndexReader reader) throws IOException {
        ArrayList<Query> similar = new ArrayList<Query>();
        for (Term t : terms) {
            List<String> fuzzy = Terms.fuzzy(reader, t);
            for (String f : fuzzy) {
                Query sq = Queries.substitute(query, t, new Term(t.field(), f));
                similar.add(sq);
            }
        }
        return similar;
    }

    public static boolean isAPhrase(String text) {
        return IS_A_PHRASE.matcher(text).matches();
    }

    @Beta
    public static Query toTermOrPhraseQuery(String field, String text) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        boolean isPhrase = Queries.isAPhrase(text);
        if (isPhrase) {
            String[] terms;
            PhraseQuery phrase = new PhraseQuery();
            for (String t : terms = text.substring(1, text.length() - 1).split("\\s+")) {
                phrase.add(new Term(field, t));
            }
            return phrase;
        }
        return new TermQuery(new Term(field, text));
    }

    @Beta
    public static List<Query> toTermOrPhraseQueries(String field, String text, Analyzer analyzer) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        boolean isPhrase = Queries.isAPhrase(text);
        if (isPhrase) {
            PhraseQuery phrase = new PhraseQuery();
            Queries.addTermsToPhrase(field, text.substring(1, text.length() - 1), analyzer, phrase);
            return Collections.singletonList(phrase);
        }
        ArrayList<Query> q = new ArrayList<Query>();
        for (String t : Fields.toTerms(field, text, analyzer)) {
            q.add((Query)new TermQuery(new Term(field, t)));
        }
        return q;
    }

    @Beta
    public static Query parseToQuery(String field, String text, Analyzer analyzer) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (!text.trim().matches(".*?\\s.*?") || Queries.isAPhrase(text)) {
            return analyzer == null ? Queries.toTermOrPhraseQuery(field, text) : Queries.or(Queries.toTermOrPhraseQueries(field, text, analyzer).toArray(new Query[0]));
        }
        Query query = null;
        boolean lastIsAND = false;
        Pattern p = Pattern.compile("(\\([^\\(]+\\))|(\\S+)");
        Matcher m = p.matcher(text);
        while (m.find()) {
            Query thisQuery = null;
            String g = m.group().trim();
            if (g.charAt(0) == '(' && g.charAt(g.length() - 1) == ')') {
                thisQuery = Queries.parseToQuery(field, g.substring(1, g.length() - 1), analyzer);
            } else if ("AND".equals(g)) {
                lastIsAND = true;
            } else if ("OR".equals(g)) {
                lastIsAND = false;
            } else {
                Query query2 = thisQuery = analyzer == null ? Queries.toTermOrPhraseQuery(field, g) : Queries.or(Queries.toTermOrPhraseQueries(field, g, analyzer).toArray(new Query[0]));
            }
            if (thisQuery == null) continue;
            query = query == null ? thisQuery : (lastIsAND ? Queries.and(query, thisQuery) : Queries.or(query, thisQuery));
            lastIsAND = false;
        }
        return query;
    }

    private static void addTermsToPhrase(String field, String text, Analyzer analyzer, PhraseQuery phrase) {
        try {
            TokenStream stream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            PositionIncrementAttribute increment = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            CharTermAttribute attribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                Term term = new Term(field, attribute.toString());
                phrase.add(term, position += increment.getPositionIncrement());
            }
            stream.end();
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Beta
    public static Query substitute(Query query, Term original, Term replacement) {
        if (query instanceof TermQuery) {
            return Queries.substitute((TermQuery)query, original, replacement);
        }
        if (query instanceof PhraseQuery) {
            return Queries.substitute((PhraseQuery)query, original, replacement);
        }
        if (query instanceof BooleanQuery) {
            return Queries.substitute((BooleanQuery)query, original, replacement);
        }
        return query;
    }

    @Beta
    public static Query substitute(BooleanQuery query, Term original, Term replacement) {
        BooleanQuery q = new BooleanQuery();
        for (BooleanClause clause : query.getClauses()) {
            Query qx = Queries.substitute(clause.getQuery(), original, replacement);
            q.add(qx, clause.getOccur());
        }
        q.setBoost(query.getBoost());
        return q;
    }

    @Beta
    public static TermQuery substitute(TermQuery query, Term original, Term replacement) {
        Term t = query.getTerm();
        if (t.equals((Object)original)) {
            return new TermQuery(replacement);
        }
        return query;
    }

    @Beta
    public static PhraseQuery substitute(PhraseQuery query, Term original, Term replacement) throws IllegalArgumentException {
        boolean doSubstitute = false;
        for (Term t : query.getTerms()) {
            if (!t.equals((Object)original)) continue;
            doSubstitute = true;
        }
        if (doSubstitute) {
            PhraseQuery q = new PhraseQuery();
            for (Term t : query.getTerms()) {
                q.add(t.equals((Object)original) ? replacement : t);
            }
            q.setSlop(query.getSlop());
            q.setBoost(query.getBoost());
            return q;
        }
        return query;
    }
}

