/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.TermFilter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class StringTermFilter
extends TermFilter<String>
implements Filter {
    private StringTermFilter(Builder builder) {
        super(builder._name, builder._terms);
    }

    @Override
    public Query filterQuery(Query base) {
        if (this._terms.values().contains(BooleanClause.Occur.SHOULD)) {
            BooleanQuery filterQuery = new BooleanQuery();
            for (String word : this._terms.keySet()) {
                filterQuery.add((Query)new TermQuery(new Term(this._name, word)), (BooleanClause.Occur)this._terms.get(word));
            }
            return base == null ? filterQuery : Queries.and(new Query[]{base, filterQuery});
        }
        if (base != null && base instanceof BooleanQuery) {
            for (String word : this._terms.keySet()) {
                ((BooleanQuery)base).add((Query)new TermQuery(new Term(this._name, word)), (BooleanClause.Occur)this._terms.get(word));
            }
            return base;
        }
        BooleanQuery filterQuery = new BooleanQuery();
        if (base != null) {
            filterQuery.add(base, BooleanClause.Occur.MUST);
        }
        for (String word : this._terms.keySet()) {
            filterQuery.add((Query)new TermQuery(new Term(this._name, word)), (BooleanClause.Occur)this._terms.get(word));
        }
        return filterQuery;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        xml.attribute("type", "string");
        for (String word : this._terms.keySet()) {
            xml.openElement("term");
            xml.attribute("text", word);
            xml.attribute("occur", StringTermFilter.occurToString((BooleanClause.Occur)this._terms.get(word)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static StringTermFilter newFilter(String name, String word) {
        return StringTermFilter.newFilter(name, word, BooleanClause.Occur.MUST);
    }

    public static StringTermFilter newFilter(String name, String word, BooleanClause.Occur occur) {
        return new Builder().name(name).addTerm(word, occur).build();
    }

    public static class Builder {
        private String _name = null;
        private final Map<String, BooleanClause.Occur> _terms = new HashMap<String, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder addTerm(String term, BooleanClause.Occur when) {
            this._terms.put(term, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public StringTermFilter build() {
            if (this._name == null) {
                throw new NullPointerException("name");
            }
            if (this._terms.isEmpty()) {
                throw new IllegalStateException("no terms to filter with!");
            }
            return new StringTermFilter(this);
        }
    }
}

