/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DateFieldFacet
extends FlexibleFieldFacet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateFieldFacet.class);
    private final DateTools.Resolution _resolution;

    protected DateFieldFacet(String name, DateTools.Resolution resolution, int maxterms) {
        super(name, maxterms);
        this._resolution = resolution;
    }

    @Override
    public String getType() {
        return "date-field";
    }

    public DateTools.Resolution getResolution() {
        return this._resolution;
    }

    @Override
    protected Query termToQuery(Term t) {
        try {
            Date d = DateTools.stringToDate((String)t.text());
            return new DateParameter(this.name(), d, this._resolution, false).toQuery();
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return new TermQuery(t);
        }
    }

    @Override
    protected void termToXML(String term, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("term");
        xml.attribute("text", term);
        try {
            xml.attribute("date", Dates.format(DateTools.stringToDate((String)term), this._resolution));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static DateFieldFacet newFacet(String field, DateTools.Resolution r) {
        return new DateFieldFacet(field, r, -1);
    }

    public static DateFieldFacet newFacet(String field, DateTools.Resolution r, int maxValues) {
        return new DateFieldFacet(field, r, maxValues);
    }
}

