/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.NumericRange;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.FieldDocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class NumericRangeFacet
extends FlexibleRangeFacet {
    private final FlintField.NumericType _numeric;
    private final List<FlexibleRangeFacet.Range> _ranges = new ArrayList<FlexibleRangeFacet.Range>();

    private NumericRangeFacet(String name, FlintField.NumericType numeric, List<FlexibleRangeFacet.Range> ranges) {
        super(name);
        this._numeric = numeric;
        this._ranges.addAll(ranges);
    }

    @Override
    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this.name().equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            this.totalRanges = 0;
            Bucket<FlexibleRangeFacet.Range> bucket = new Bucket<FlexibleRangeFacet.Range>(size);
            DocumentCounter counter = new DocumentCounter();
            for (FlexibleRangeFacet.Range r : this._ranges) {
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.rangeToQuery(r), BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                bucket.add(r, count);
                counter.reset();
                if (count <= 0) continue;
                ++this.totalRanges;
            }
            this._bucket = bucket;
            FieldDocumentCounter totalCounter = new FieldDocumentCounter(this.name());
            searcher.search(filtered, (Collector)totalCounter);
            this.totalResults = totalCounter.getCount();
        }
    }

    @Override
    protected void compute(IndexSearcher searcher, int size) throws IOException {
        this.totalRanges = 0;
        Bucket<FlexibleRangeFacet.Range> bucket = new Bucket<FlexibleRangeFacet.Range>(size);
        DocumentCounter counter = new DocumentCounter();
        for (FlexibleRangeFacet.Range r : this._ranges) {
            searcher.search(this.rangeToQuery(r), (Collector)counter);
            int count = counter.getCount();
            bucket.add(r, count);
            counter.reset();
            if (count <= 0) continue;
            ++this.totalRanges;
        }
        this._bucket = bucket;
        this.totalResults = 0;
    }

    protected Query rangeToQuery(FlexibleRangeFacet.Range r) {
        switch (this._numeric) {
            case INT: {
                return NumericRange.newIntRange(this.name(), r.getMin() == null ? null : Integer.valueOf(Integer.parseInt(r.getMin())), r.getMax() == null ? null : Integer.valueOf(Integer.parseInt(r.getMax())), r.includeMin(), r.includeMax()).toQuery();
            }
            case LONG: {
                return NumericRange.newLongRange(this.name(), r.getMin() == null ? null : Long.valueOf(Long.parseLong(r.getMin())), r.getMax() == null ? null : Long.valueOf(Long.parseLong(r.getMax())), r.includeMin(), r.includeMax()).toQuery();
            }
            case DOUBLE: {
                return NumericRange.newDoubleRange(this.name(), r.getMin() == null ? null : Double.valueOf(Double.parseDouble(r.getMin())), r.getMax() == null ? null : Double.valueOf(Double.parseDouble(r.getMax())), r.includeMin(), r.includeMax()).toQuery();
            }
            case FLOAT: {
                return NumericRange.newFloatRange(this.name(), r.getMin() == null ? null : Float.valueOf(Float.parseFloat(r.getMin())), r.getMax() == null ? null : Float.valueOf(Float.parseFloat(r.getMax())), r.includeMin(), r.includeMax()).toQuery();
            }
        }
        return null;
    }

    @Override
    protected String termToText(Term t) {
        return null;
    }

    @Override
    protected Query termToQuery(Term t) {
        return null;
    }

    @Override
    protected FlexibleRangeFacet.Range findRange(Term t) {
        return null;
    }

    @Override
    protected String getType() {
        return "numeric-range";
    }

    @Override
    protected void rangeToXML(FlexibleRangeFacet.Range range, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("range");
        if (range.getMin() != null) {
            xml.attribute("min", range.getMin());
        }
        if (range.getMax() != null) {
            xml.attribute("max", range.getMax());
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static class Builder {
        private final List<FlexibleRangeFacet.Range> ranges = new ArrayList<FlexibleRangeFacet.Range>();
        private FlintField.NumericType numeric = null;
        private String name = null;

        public Builder numeric(FlintField.NumericType num) {
            this.numeric = num;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder addRange(Number min, boolean withMin, Number max, boolean withMax) {
            this.ranges.add(FlexibleRangeFacet.Range.numericRange(min, withMin, max, withMax));
            return this;
        }

        public Builder addRange(FlexibleRangeFacet.Range range) {
            this.ranges.add(range);
            return this;
        }

        public Builder addRange(Number min, Number max) {
            return this.addRange(min, true, max, true);
        }

        public NumericRangeFacet build() {
            if (this.name == null) {
                throw new NullPointerException("Must have a field name");
            }
            if (this.numeric == null) {
                throw new NullPointerException("Must have a numeric type");
            }
            NumericRangeFacet fr = new NumericRangeFacet(this.name, this.numeric, this.ranges);
            return fr;
        }
    }
}

