/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

public final class DateParameter
implements SearchParameter {
    private final String _field;
    private Date _from;
    private Date _to;
    private DateTools.Resolution _resolution = DateTools.Resolution.DAY;
    private boolean _minInclusive;
    private boolean _maxInclusive;
    private boolean _numeric = false;
    private volatile Query _query;

    public DateParameter(String field, Date from, Date to, DateTools.Resolution resolution, boolean numeric) {
        this(field, from, to, true, true, resolution, numeric);
    }

    public DateParameter(String field, Date from, Date to, boolean withMin, boolean withMax, DateTools.Resolution resolution, boolean numeric) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (resolution == null) {
            throw new NullPointerException("resolution");
        }
        this._field = field;
        this._from = from;
        this._to = to;
        this._minInclusive = withMin;
        this._maxInclusive = withMax;
        this._resolution = resolution;
        this._numeric = numeric;
    }

    public DateParameter(String field, Date exactMatch, DateTools.Resolution resolution, boolean numeric) {
        this(field, exactMatch, exactMatch, true, true, resolution, numeric);
    }

    public Date from() {
        return this._from != null ? new Date(this._from.getTime()) : null;
    }

    public Date to() {
        return this._to != null ? new Date(this._to.getTime()) : null;
    }

    public String field() {
        return this._field;
    }

    @Override
    public boolean isEmpty() {
        return this._from == null && this._to == null;
    }

    public boolean isMaxIncluded() {
        return this._maxInclusive;
    }

    public boolean isMinIncluded() {
        return this._minInclusive;
    }

    @Override
    public Query toQuery() {
        if (this._from == null && this._to == null) {
            return null;
        }
        if (this._query == null) {
            this._query = this._numeric ? DateParameter.toNumericRangeQuery(this._field, this._from, this._to, this._minInclusive, this._maxInclusive, this._resolution) : DateParameter.toTermRangeQuery(this._field, this._from, this._to, this._minInclusive, this._maxInclusive, this._resolution);
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("date-range", false);
        xml.attribute("field", this._field);
        if (this._from != null) {
            xml.attribute("from", Dates.format(this._from, this._resolution));
        }
        if (this._to != null) {
            xml.attribute("to", Dates.format(this._to, this._resolution));
        }
        xml.closeElement();
    }

    public String toString() {
        Query q = this.toQuery();
        return q == null ? "[empty]" : q.toString();
    }

    private static TermRangeQuery toTermRangeQuery(String field, Date from, Date to, boolean withMin, boolean withMax, DateTools.Resolution resolution) {
        BytesRef min = from != null ? new BytesRef(Dates.toString(from, resolution).getBytes()) : null;
        BytesRef max = to != null ? new BytesRef(Dates.toString(to, resolution).getBytes()) : null;
        return new TermRangeQuery(field, min, max, withMin, withMax);
    }

    private static NumericRangeQuery<? extends Number> toNumericRangeQuery(String field, Date from, Date to, boolean withMin, boolean withMax, DateTools.Resolution resolution) {
        Number max;
        Number min = from != null ? (Number)Dates.toNumber(from, resolution) : (Number)null;
        Number number = max = to != null ? (Number)Dates.toNumber(to, resolution) : (Number)null;
        if (min instanceof Long || min == null && max instanceof Long) {
            return NumericRangeQuery.newLongRange((String)field, (Long)((Long)min), (Long)((Long)max), (boolean)withMin, (boolean)withMax);
        }
        if (min instanceof Integer || min == null && max instanceof Integer) {
            return NumericRangeQuery.newIntRange((String)field, (Integer)((Integer)min), (Integer)((Integer)max), (boolean)withMin, (boolean)withMax);
        }
        return null;
    }
}

