/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.NumberParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class NumericTermFilter
implements Filter {
    private final String _name;
    private FlintField.NumericType _numeric = null;
    private final Map<Number, BooleanClause.Occur> _values = new HashMap<Number, BooleanClause.Occur>();

    private NumericTermFilter(Builder builder) {
        this._name = builder._name;
        this._numeric = builder._numeric;
        this._values.putAll(builder._values);
    }

    @Override
    public Query filterQuery(Query base) {
        BooleanQuery filterQuery = new BooleanQuery();
        for (Number value : this._values.keySet()) {
            BooleanClause.Occur clause = this._values.get(value);
            filterQuery.add(this.numberToQuery(value), clause);
        }
        return base == null ? filterQuery : Queries.and(new Query[]{base, filterQuery});
    }

    @Override
    public String name() {
        return this._name;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        xml.attribute("type", "numeric");
        for (Number value : this._values.keySet()) {
            xml.openElement("term");
            xml.attribute("text", String.valueOf(value));
            xml.attribute("occur", NumericTermFilter.occurToString(this._values.get(value)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static NumericTermFilter newFilter(String name, Number value) {
        return NumericTermFilter.newFilter(name, value, BooleanClause.Occur.MUST);
    }

    public static NumericTermFilter newFilter(String name, Number value, BooleanClause.Occur occur) {
        FlintField.NumericType numeric;
        if (value instanceof Integer) {
            numeric = FlintField.NumericType.INT;
        } else if (value instanceof Float) {
            numeric = FlintField.NumericType.FLOAT;
        } else if (value instanceof Double) {
            numeric = FlintField.NumericType.DOUBLE;
        } else if (value instanceof Long) {
            numeric = FlintField.NumericType.LONG;
        } else {
            return null;
        }
        return new Builder().name(name).numeric(numeric).addNumber(value, occur).build();
    }

    private Query numberToQuery(Number value) {
        switch (this._numeric) {
            case INT: {
                return NumberParameter.newIntParameter(this._name, (Integer)value).toQuery();
            }
            case LONG: {
                return NumberParameter.newLongParameter(this._name, (Long)value).toQuery();
            }
            case DOUBLE: {
                return NumberParameter.newDoubleParameter(this._name, NumericUtils.sortableLongToDouble((long)((Long)value))).toQuery();
            }
            case FLOAT: {
                return NumberParameter.newFloatParameter(this._name, Float.valueOf(NumericUtils.sortableIntToFloat((int)((Integer)value)))).toQuery();
            }
        }
        return null;
    }

    private static String occurToString(BooleanClause.Occur occur) {
        if (occur == BooleanClause.Occur.MUST) {
            return "must";
        }
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return "must_not";
        }
        if (occur == BooleanClause.Occur.SHOULD) {
            return "should";
        }
        return "unknown";
    }

    public static class Builder {
        private String _name = null;
        private FlintField.NumericType _numeric = null;
        private final Map<Number, BooleanClause.Occur> _values = new HashMap<Number, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder numeric(FlintField.NumericType numeric) {
            this._numeric = numeric;
            return this;
        }

        public Builder addNumber(Number value, BooleanClause.Occur when) {
            this._values.put(value, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public NumericTermFilter build() {
            if (this._name == null) {
                throw new NullPointerException("name");
            }
            if (this._numeric == null) {
                throw new NullPointerException("numeric");
            }
            if (this._values.isEmpty()) {
                throw new IllegalStateException("no values to filter with!");
            }
            return new NumericTermFilter(this);
        }
    }
}

