/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.OpenIndexManager;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneIndexIO
implements IndexIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexIO.class);
    public static final String LAST_COMMIT_DATE = "lastCommitDate";
    private volatile State state = State.CLEAN;
    private final AtomicLong lastTimeUsed = new AtomicLong(0L);
    private IndexWriter _writer;
    private ReaderManager _reader;
    private final Directory _directory;
    private final Analyzer _analyzer;
    private SearcherManager _searcher;
    private Integer writing = 0;
    private Integer committing = 0;
    private static final SearcherFactory FACTORY = new SearcherFactory();

    public LuceneIndexIO(Directory dir, Analyzer analyzer) throws IndexException {
        this._analyzer = analyzer;
        this._directory = dir;
        try {
            this.open();
        }
        catch (IOException ex) {
            throw new IndexException("Failed to create writer on index", (Exception)ex);
        }
        try {
            String lastCommitDate;
            List commits = DirectoryReader.listCommits((Directory)dir);
            if (commits != null && !commits.isEmpty() && (lastCommitDate = (String)((IndexCommit)commits.get(commits.size() - 1)).getUserData().get(LAST_COMMIT_DATE)) != null) {
                this.lastTimeUsed.set(Long.parseLong(lastCommitDate));
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load last index commit date", (Throwable)ex);
        }
        OpenIndexManager.add((IndexIO)this);
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed.get();
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public synchronized void stop() throws IndexException {
        if (this._writer == null || this.isState(State.CLOSED) || this.isState(State.CLOSING)) {
            return;
        }
        LOGGER.debug("Stopping IO");
        this.maybeCommit();
        if (this._writer == null || this.isState(State.CLOSED) || this.isState(State.CLOSING)) {
            return;
        }
        this.startClosing();
        try {
            this._writer.close();
            this._searcher.close();
            this._reader.close();
            this.state(State.CLOSED);
            OpenIndexManager.remove((IndexIO)this);
        }
        catch (CorruptIndexException ex) {
            throw new IndexException("Failed to close Index because it is corrupted", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new IndexException("Failed to close Index because of an I/O error", (Exception)ex);
        }
        finally {
            this.endCommitting();
        }
    }

    public synchronized void maybeRefresh() {
        if (this._writer == null || !this._writer.isOpen() || !this.isState(State.DIRTY)) {
            return;
        }
        try {
            LOGGER.debug("Reopen reader and searcher");
            this._reader.maybeRefresh();
            this._searcher.maybeRefresh();
            this.state(State.CLEAN);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to reopen Index Searcher because of an I/O error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void maybeCommit() {
        if (this._writer == null || this.isState(State.CLOSING) || this.isState(State.CLOSED) || this.committing > 0 || !this._writer.hasDeletions() && !this._writer.hasUncommittedChanges() && !this._writer.hasPendingMerges()) {
            return;
        }
        this.state(State.DIRTY);
        this.maybeRefresh();
        if (this._writer == null || !this._writer.isOpen() || this.committing > 0 || this.isState(State.CLOSING) || this.isState(State.CLOSED)) {
            return;
        }
        this.startCommitting();
        try {
            LOGGER.debug("Committing index changes");
            long now = System.currentTimeMillis();
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            commitUserData.put(LAST_COMMIT_DATE, String.valueOf(now));
            this._writer.setCommitData(commitUserData);
            this._writer.commit();
            this.lastTimeUsed.set(now);
        }
        catch (CorruptIndexException ex) {
            LOGGER.error("Failed to commit Index because it is corrupted", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to commit Index because of an I/O error", (Throwable)ex);
        }
        finally {
            this.endCommitting();
        }
    }

    public synchronized boolean clearIndex() throws IndexException {
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            this.startWriting();
            this._writer.deleteAll();
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to clear Index", (Exception)ex);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized boolean deleteDocuments(DeleteRule rule) throws IndexException {
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        if (!(rule instanceof LuceneDeleteRule)) {
            return false;
        }
        LuceneDeleteRule drule = (LuceneDeleteRule)rule;
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            this.startWriting();
            if (drule.useTerm()) {
                this._writer.deleteDocuments(new Term[]{drule.toTerm()});
            } else {
                this._writer.deleteDocuments(new Query[]{drule.toQuery()});
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to clear Index", (Exception)ex);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized boolean updateDocuments(DeleteRule rule, List<FlintDocument> documents) throws IndexException {
        LuceneDeleteRule drule;
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        if (rule == null) {
            drule = null;
        } else {
            if (!(rule instanceof LuceneDeleteRule)) {
                return false;
            }
            drule = (LuceneDeleteRule)rule;
        }
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            this.startWriting();
            List<Document> docs = LuceneUtils.toDocuments(documents);
            if (rule != null) {
                if (drule.useTerm()) {
                    this._writer.updateDocuments(drule.toTerm(), docs);
                } else {
                    this._writer.deleteDocuments(new Query[]{drule.toQuery()});
                    this._writer.addDocuments(docs);
                }
            } else {
                this._writer.addDocuments(docs);
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException e) {
            throw new IndexException("Failed to update document in Index because of an I/O error", (Exception)e);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public synchronized boolean updateDocValues(Term term, Field ... newFields) throws IndexException {
        if (this._writer == null || this.isState(State.CLOSING)) {
            return false;
        }
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            this.startWriting();
            this._writer.updateDocValues(term, newFields);
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state(State.DIRTY);
        }
        catch (IOException ex) {
            throw new IndexException("Failed to update docvalues in Index because of an I/O error", (Exception)ex);
        }
        finally {
            this.endWriting();
        }
        return true;
    }

    public IndexSearcher bookSearcher() {
        if (this.isState(State.CLOSING)) {
            return null;
        }
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            return (IndexSearcher)this._searcher.acquire();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to book searcher", (Throwable)ex);
            return null;
        }
    }

    public void releaseSearcher(IndexSearcher searcher) {
        if (this.isState(State.CLOSED) || this.isState(State.CLOSING)) {
            return;
        }
        try {
            this._searcher.release((Object)searcher);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release searcher", (Throwable)ex);
        }
    }

    public IndexReader bookReader() {
        if (this.isState(State.CLOSING)) {
            return null;
        }
        try {
            if (this.isState(State.CLOSED)) {
                this.open();
            }
            return (IndexReader)this._reader.acquire();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to book reader", (Throwable)ex);
            return null;
        }
    }

    public void releaseReader(IndexReader reader) {
        if (this.isState(State.CLOSED) || this.isState(State.CLOSING)) {
            return;
        }
        if (!(reader instanceof DirectoryReader)) {
            throw new IllegalArgumentException("Reader must be a DirectoryReader");
        }
        try {
            this._reader.release((Object)((DirectoryReader)reader));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release reader", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void state(State s) {
        State state = this.state;
        synchronized (state) {
            this.state = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isState(State s) {
        State state = this.state;
        synchronized (state) {
            return this.state == s;
        }
    }

    private void startClosing() {
        this.state(State.CLOSING);
        while (this.writing > 0 || this.committing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for writing to finish", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommitting() {
        while (this.writing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for writing to finish", (Throwable)ex);
            }
        }
        Integer n = this.committing;
        synchronized (n) {
            LuceneIndexIO luceneIndexIO = this;
            Integer n2 = luceneIndexIO.committing;
            Integer n3 = luceneIndexIO.committing = Integer.valueOf(luceneIndexIO.committing + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endCommitting() {
        Integer n = this.committing;
        synchronized (n) {
            LuceneIndexIO luceneIndexIO = this;
            Integer n2 = luceneIndexIO.committing;
            Integer n3 = luceneIndexIO.committing = Integer.valueOf(luceneIndexIO.committing - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriting() {
        while (this.committing > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOGGER.error("Interrupted while waiting for commit to finish", (Throwable)ex);
            }
        }
        Integer n = this.writing;
        synchronized (n) {
            LuceneIndexIO luceneIndexIO = this;
            Integer n2 = luceneIndexIO.writing;
            Integer n3 = luceneIndexIO.writing = Integer.valueOf(luceneIndexIO.writing + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endWriting() {
        Integer n = this.writing;
        synchronized (n) {
            LuceneIndexIO luceneIndexIO = this;
            Integer n2 = luceneIndexIO.writing;
            Integer n3 = luceneIndexIO.writing = Integer.valueOf(luceneIndexIO.writing - 1);
        }
    }

    private void open() throws IOException {
        boolean createIt = !DirectoryReader.indexExists((Directory)this._directory);
        boolean readonly = LuceneIndexIO.isReadOnly(this._directory);
        if (readonly) {
            this._writer = null;
            this._reader = new ReaderManager(this._directory);
            this._searcher = new SearcherManager(this._directory, FACTORY);
        } else {
            IndexWriterConfig config = new IndexWriterConfig(this._analyzer);
            ConcurrentMergeScheduler merger = new ConcurrentMergeScheduler();
            config.setMergeScheduler((MergeScheduler)merger);
            if (createIt) {
                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            }
            this._writer = new IndexWriter(this._directory, config);
            if (createIt) {
                this._writer.commit();
            }
            boolean applyAllDeletes = true;
            this._searcher = new SearcherManager(this._writer, applyAllDeletes, FACTORY);
            this._reader = new ReaderManager(this._writer, applyAllDeletes);
        }
    }

    private static boolean isReadOnly(Directory directory) {
        if (!(directory instanceof FSDirectory)) {
            return false;
        }
        try {
            File f = ((FSDirectory)directory).getDirectory().toFile();
            if (!f.canWrite()) {
                return true;
            }
            for (File tf : f.listFiles()) {
                if (tf.canWrite()) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Index is readonly", (Throwable)ex);
            return true;
        }
        return false;
    }

    private static enum State {
        CLEAN,
        DIRTY,
        CLOSING,
        CLOSED;

    }
}

