/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public abstract class FlexibleIntervalFacet
implements XMLWritable {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    private final String _name;
    private final String _start;
    private final String _end;
    private final boolean _includeLower;
    private final boolean _includeLastUpper;
    protected transient Bucket<Interval> _bucket;
    protected final int _maxIntervals;
    protected transient boolean flexible = false;
    protected transient int totalIntervals = 0;

    protected FlexibleIntervalFacet(String name, String start, String end, boolean includeLower, boolean includeLastUpper, int maxIntervals) {
        this._name = name;
        this._start = start;
        this._end = end;
        this._includeLower = includeLower;
        this._includeLastUpper = includeLastUpper;
        this._maxIntervals = maxIntervals;
    }

    public String name() {
        return this._name;
    }

    public String start() {
        return this._start;
    }

    public String end() {
        return this._end;
    }

    public boolean includeLower() {
        return this._includeLower;
    }

    public boolean includeLastUpper() {
        return this._includeLastUpper;
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.totalIntervals = 0;
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this._name.equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            HashMap<Interval, Integer> intervals = new HashMap<Interval, Integer>();
            DocumentCounter counter = new DocumentCounter();
            for (Term t : terms) {
                Interval r = this.findInterval(t);
                if (r == null) continue;
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.termToQuery(t), BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                if (count > 0) {
                    Integer ec = (Integer)intervals.get(r);
                    intervals.put(r, count + (ec == null ? 0 : ec));
                    if (this._maxIntervals > 0 && intervals.size() > this._maxIntervals) {
                        return;
                    }
                }
                counter.reset();
            }
            this.totalIntervals = intervals.size();
            Bucket<Interval> b = new Bucket<Interval>(size);
            for (Interval interval : intervals.keySet()) {
                b.add(interval, (Integer)intervals.get(interval));
            }
            this._bucket = b;
        }
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        this.compute(searcher, base, null, size);
    }

    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, null, 10);
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base, filters, 10);
    }

    private void compute(IndexSearcher searcher, int size) throws IOException {
        List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
        DocumentCounter counter = new DocumentCounter();
        HashMap<Interval, Integer> intervals = new HashMap<Interval, Integer>();
        for (Term t : terms) {
            Interval interval = this.findInterval(t);
            if (interval == null) continue;
            searcher.search(this.termToQuery(t), (Collector)counter);
            int count = counter.getCount();
            if (count > 0) {
                Integer ec = (Integer)intervals.get(interval);
                intervals.put(interval, count + (ec == null ? 0 : ec));
                if (this._maxIntervals > 0 && intervals.size() > this._maxIntervals) {
                    return;
                }
            }
            counter.reset();
        }
        this.totalIntervals = intervals.size();
        Bucket<Interval> b = new Bucket<Interval>(size);
        for (Interval interval : intervals.keySet()) {
            b.add(interval, (Integer)intervals.get(interval));
        }
        this._bucket = b;
    }

    protected abstract Query termToQuery(Term var1);

    protected abstract String getType();

    protected abstract void intervalToXML(Interval var1, int var2, XMLWriter var3) throws IOException;

    protected abstract Interval findInterval(Term var1);

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("start", this._start);
        if (this._end != null) {
            xml.attribute("end", this._end);
        }
        xml.attribute("type", this.getType());
        xml.attribute("flexible", String.valueOf(this.flexible));
        if (!this.flexible) {
            xml.attribute("total-intervals", this.totalIntervals);
        }
        if (this._bucket != null) {
            for (Bucket.Entry<Interval> e : this._bucket.entrySet()) {
                this.intervalToXML(e.item(), e.count(), xml);
            }
        }
        xml.closeElement();
    }

    public Bucket<Interval> getValues() {
        return this._bucket;
    }

    public int getTotalIntervals() {
        return this.totalIntervals;
    }

    public static class Interval
    implements Comparable<Interval> {
        private final String min;
        private final String max;
        private boolean includeMin;
        private boolean includeMax;

        private Interval(String mi, boolean withMin, String ma, boolean withMax) {
            this.max = ma;
            this.min = mi;
            this.includeMin = withMin;
            this.includeMax = withMax;
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        protected boolean includeMax() {
            return this.includeMax;
        }

        protected boolean includeMin() {
            return this.includeMin;
        }

        public String toString() {
            return (this.includeMin ? (char)'[' : '{') + this.min + '-' + this.max + (this.includeMax ? (char)']' : '}');
        }

        public boolean equals(Object obj) {
            if (obj instanceof Interval) {
                Interval r = (Interval)obj;
                return (r.min == null && this.min == null || r.min != null && r.min.equals(this.min)) && (r.max == null && this.max == null || r.max != null && r.max.equals(this.max)) && this.includeMin == r.includeMin && this.includeMax == r.includeMax;
            }
            return false;
        }

        public int hashCode() {
            return (this.min != null ? this.min.hashCode() * 13 : 13) + (this.max != null ? this.max.hashCode() * 11 : 11) + (this.includeMin ? 17 : 7) + (this.includeMax ? 5 : 3);
        }

        @Override
        public int compareTo(Interval o) {
            if (this.min == null) {
                if (o.min != null) {
                    return -1;
                }
                if (this.max == null) {
                    return -1;
                }
                if (o.max == null) {
                    return 1;
                }
                return this.max.compareTo(o.max);
            }
            if (o.min == null) {
                return 1;
            }
            return this.min.compareTo(o.min);
        }

        public static Interval stringInterval(String mi, String ma) {
            return Interval.stringInterval(mi, true, ma, false);
        }

        public static Interval stringInterval(String mi, boolean withMin, String ma, boolean withMax) {
            return new Interval(mi, withMin, ma, withMax);
        }

        public static Interval numericInterval(Number mi, Number ma) {
            return Interval.numericInterval(mi, true, ma, false);
        }

        public static Interval numericInterval(Number mi, boolean withMin, Number ma, boolean withMax) {
            return new Interval(mi == null ? null : mi.toString(), withMin, ma == null ? null : ma.toString(), withMax);
        }

        public static Interval dateInterval(Date mi, Date ma, DateTools.Resolution res) {
            return Interval.dateInterval(mi, true, ma, false, res);
        }

        public static Interval dateInterval(Date mi, boolean withMin, Date ma, boolean withMax, DateTools.Resolution res) {
            return new Interval(Dates.toString(mi, res), withMin, Dates.toString(ma, res), withMax);
        }

        public static Interval dateInterval(OffsetDateTime mi, OffsetDateTime ma, DateTools.Resolution res) {
            return Interval.dateInterval(mi, true, ma, false, res);
        }

        public static Interval dateInterval(OffsetDateTime mi, boolean withMin, OffsetDateTime ma, boolean withMax, DateTools.Resolution res) {
            return new Interval(Dates.toString(mi, res), withMin, Dates.toString(ma, res), withMax);
        }
    }
}

