/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DateRangeFacet
extends FlexibleRangeFacet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateRangeFacet.class);
    private final DateTools.Resolution _resolution;
    private final List<FlexibleRangeFacet.Range> _ranges = new ArrayList<FlexibleRangeFacet.Range>();

    private DateRangeFacet(String name, DateTools.Resolution resolution, List<FlexibleRangeFacet.Range> ranges) {
        super(name);
        this._resolution = resolution;
        this._ranges.addAll(ranges);
    }

    @Override
    protected Query termToQuery(Term t) {
        try {
            Date d = DateTools.stringToDate((String)t.text());
            return new DateParameter(this.name(), d, this._resolution, false).toQuery();
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return new TermQuery(t);
        }
    }

    @Override
    protected String getType() {
        return "date-range";
    }

    @Override
    protected FlexibleRangeFacet.Range findRange(Term t) {
        Date d;
        if (t == null) {
            return null;
        }
        try {
            d = DateTools.stringToDate((String)t.text());
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return null;
        }
        for (FlexibleRangeFacet.Range r : this._ranges) {
            boolean passMax;
            boolean passMin;
            boolean bl = passMin = r.getMin() == null;
            if (!passMin) {
                try {
                    Date m = DateTools.stringToDate((String)r.getMin());
                    passMin = m.before(d) || r.includeMin() && m.equals(d);
                }
                catch (ParseException ex) {
                    LOGGER.warn("Ignoring invalid facet range date {} for field {}", new Object[]{r.getMin(), this.name(), ex});
                }
            }
            boolean bl2 = passMax = r.getMax() == null;
            if (!passMax) {
                try {
                    Date m = DateTools.stringToDate((String)r.getMax());
                    passMax = d.before(m) || r.includeMax() && m.equals(d);
                }
                catch (ParseException ex) {
                    LOGGER.warn("Ignoring invalid facet range date {} for field {}", new Object[]{r.getMax(), this.name(), ex});
                }
            }
            if (!passMin || !passMax) continue;
            return r;
        }
        return null;
    }

    @Override
    protected void rangeToXML(FlexibleRangeFacet.Range range, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("range");
        if (range.getMin() != null) {
            try {
                xml.attribute("min", Dates.format(DateTools.stringToDate((String)range.getMin()), this._resolution));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (range.getMax() != null) {
            try {
                xml.attribute("max", Dates.format(DateTools.stringToDate((String)range.getMax()), this._resolution));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (range.getMin() != null) {
            xml.attribute("include-min", range.includeMin() ? "true" : "false");
        }
        if (range.getMax() != null) {
            xml.attribute("include-max", range.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    private static class DateRange {
        private Date min;
        private Date max;
        private boolean withMin;
        private boolean withMax;

        private DateRange() {
        }
    }

    public static class Builder {
        private final List<DateRange> dateranges = new ArrayList<DateRange>();
        private final List<FlexibleRangeFacet.Range> ranges = new ArrayList<FlexibleRangeFacet.Range>();
        private DateTools.Resolution resolution = null;
        private String name = null;

        public Builder resolution(DateTools.Resolution res) {
            this.resolution = res;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder addRange(Date min, boolean withMin, Date max, boolean withMax) {
            DateRange dr = new DateRange();
            dr.min = min;
            dr.max = max;
            dr.withMax = withMax;
            dr.withMin = withMin;
            this.dateranges.add(dr);
            return this;
        }

        public Builder addRange(Date min, Date max) {
            return this.addRange(min, true, max, true);
        }

        public Builder addRange(FlexibleRangeFacet.Range range) {
            this.ranges.add(range);
            return this;
        }

        public DateRangeFacet build() {
            if (this.name == null) {
                throw new NullPointerException("Must have a field name");
            }
            if (this.resolution == null) {
                throw new NullPointerException("Must have a resolution");
            }
            for (DateRange dr : this.dateranges) {
                this.ranges.add(FlexibleRangeFacet.Range.dateRange(dr.min, dr.withMin, dr.max, dr.withMax, this.resolution));
            }
            return new DateRangeFacet(this.name, this.resolution, this.ranges);
        }
    }
}

