/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class Question
implements SearchParameter,
XMLWritable {
    private final boolean _supportOperators;
    private final String _question;
    private final Map<String, Float> _fields;
    private Query _query = null;

    protected Question(Map<String, Float> fields, String question, boolean supportOperators) throws NullPointerException {
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        if (question == null) {
            throw new NullPointerException("question");
        }
        this._fields = fields;
        this._question = question;
        this._supportOperators = supportOperators;
    }

    public Collection<String> fields() {
        return this._fields.keySet();
    }

    public String question() {
        return this._question;
    }

    public float getBoost(String field) {
        Float boost = this._fields.get(field);
        return boost != null ? boost.floatValue() : 1.0f;
    }

    @Override
    public boolean isEmpty() {
        return this._question.isEmpty() || this._fields.isEmpty();
    }

    private void compute(Analyzer analyzer, Catalog catalog) {
        BooleanQuery query = new BooleanQuery();
        if (this._supportOperators) {
            for (Map.Entry<String, Float> e : this._fields.entrySet()) {
                Query q = catalog != null && !catalog.isTokenized(e.getKey()) ? new TermQuery(new Term(e.getKey(), this._question)) : Queries.parseToQuery(e.getKey(), this._question, analyzer);
                q.setBoost(e.getValue().floatValue());
                query.add(q, BooleanClause.Occur.SHOULD);
            }
        } else {
            List<String> values = Fields.toValues(this._question);
            for (Map.Entry<String, Float> e : this._fields.entrySet()) {
                boolean analyzed = catalog == null || catalog.isTokenized(e.getKey());
                BooleanQuery sub = new BooleanQuery();
                for (String value : values) {
                    if (!analyzed) {
                        TermQuery q = new TermQuery(new Term(e.getKey(), value));
                        q.setBoost(e.getValue().floatValue());
                        sub.add((Query)q, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    for (Query q : Queries.toTermOrPhraseQueries(e.getKey(), value, analyzer)) {
                        q.setBoost(e.getValue().floatValue());
                        sub.add(q, BooleanClause.Occur.SHOULD);
                    }
                }
                query.add((Query)sub, BooleanClause.Occur.SHOULD);
            }
        }
        this._query = query;
    }

    private void compute() {
        BooleanQuery query = new BooleanQuery();
        if (this._supportOperators) {
            for (Map.Entry<String, Float> e : this._fields.entrySet()) {
                Query q = Queries.parseToQuery(e.getKey(), this._question, null);
                q.setBoost(e.getValue().floatValue());
                query.add(q, BooleanClause.Occur.SHOULD);
            }
        } else {
            List<String> values = Fields.toValues(this._question);
            for (Map.Entry<String, Float> e : this._fields.entrySet()) {
                BooleanQuery sub = new BooleanQuery();
                for (String value : values) {
                    Query q = Queries.toTermOrPhraseQuery(e.getKey(), value);
                    q.setBoost(e.getValue().floatValue());
                    sub.add(q, BooleanClause.Occur.SHOULD);
                }
                query.add((Query)sub, BooleanClause.Occur.SHOULD);
            }
        }
        this._query = query;
    }

    public List<Question> similar(IndexReader reader) throws IOException {
        ArrayList<Question> similar = new ArrayList<Question>();
        if (this._question.indexOf(34) >= 0) {
            Question nophrase = Question.newQuestion(this._fields, this._question.replace('\"', ' '));
            nophrase.compute();
            similar.add(nophrase);
        } else {
            List<String> values = Fields.toValues(this._question);
            for (String value : values) {
                HashSet<String> fuzzy = new HashSet<String>();
                for (String field : this._fields.keySet()) {
                    List<String> fuzzies = Terms.fuzzy(reader, new Term(field, value));
                    if (fuzzies == null) continue;
                    fuzzy.addAll(fuzzies);
                }
                for (String x : fuzzy) {
                    Question q = Question.newQuestion(this._fields, this._question.replaceAll("\\Q" + value + "\\E", x));
                    q.compute();
                    similar.add(q);
                }
            }
        }
        return similar;
    }

    @Override
    public Query toQuery() throws IllegalStateException {
        if (this.isEmpty()) {
            return null;
        }
        if (this._query == null) {
            throw new IllegalStateException("Query has not been computed - call compute(Analyzer)");
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("question", true);
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (this._query != null) {
            xml.attribute("query", this._query.toString());
        }
        for (Map.Entry<String, Float> field : this._fields.entrySet()) {
            xml.openElement("field");
            Float boost = field.getValue();
            xml.attribute("boost", boost != null ? boost.toString() : "1.0");
            xml.writeText(field.getKey());
            xml.closeElement();
        }
        xml.element("text", this._question);
        xml.closeElement();
    }

    public String toString() {
        return this._question + " in " + this._fields.entrySet();
    }

    public static Question newQuestion(String field, String question) {
        return Question.newQuestion(Collections.singletonMap(field, Float.valueOf(1.0f)), question);
    }

    public static Question newQuestion(String field, String question, Analyzer analyzer) {
        return Question.newQuestion(field, question, analyzer, null);
    }

    public static Question newQuestion(String field, String question, Analyzer analyzer, Catalog catalog) {
        return Question.newQuestion(Collections.singletonMap(field, Float.valueOf(1.0f)), question, analyzer, catalog);
    }

    public static Question newQuestion(List<String> fields, String question) {
        return Question.newQuestion(Fields.asBoostMap(Fields.filterNames(fields)), question);
    }

    public static Question newQuestion(List<String> fields, String question, Analyzer analyzer) {
        return Question.newQuestion(fields, question, analyzer, null);
    }

    public static Question newQuestion(List<String> fields, String question, Analyzer analyzer, Catalog catalog) {
        return Question.newQuestion(Fields.asBoostMap(Fields.filterNames(fields)), question, analyzer, catalog);
    }

    public static Question newQuestion(Map<String, Float> fields, String question) {
        Question q = new Question(fields, question, false);
        q.compute();
        return q;
    }

    public static Question newQuestion(Map<String, Float> fields, String question, Analyzer analyzer) {
        return Question.newQuestion(fields, question, analyzer, null);
    }

    public static Question newQuestion(Map<String, Float> fields, String question, Analyzer analyzer, Catalog catalog) {
        Question q = new Question(fields, question, false);
        q.compute(analyzer, catalog);
        return q;
    }

    public static Question newQuestionWithOperators(String field, String question) {
        return Question.newQuestionWithOperators(Collections.singletonMap(field, Float.valueOf(1.0f)), question);
    }

    public static Question newQuestionWithOperators(String field, String question, Analyzer analyzer) {
        return Question.newQuestionWithOperators(field, question, analyzer, null);
    }

    public static Question newQuestionWithOperators(String field, String question, Analyzer analyzer, Catalog catalog) {
        return Question.newQuestion(Collections.singletonMap(field, Float.valueOf(1.0f)), question, analyzer, catalog);
    }

    public static Question newQuestionWithOperators(List<String> fields, String question) {
        return Question.newQuestionWithOperators(Fields.asBoostMap(Fields.filterNames(fields)), question);
    }

    public static Question newQuestionWithOperators(List<String> fields, String question, Analyzer analyzer) {
        return Question.newQuestionWithOperators(fields, question, analyzer, null);
    }

    public static Question newQuestionWithOperators(List<String> fields, String question, Analyzer analyzer, Catalog catalog) {
        return Question.newQuestionWithOperators(Fields.asBoostMap(Fields.filterNames(fields)), question, analyzer, catalog);
    }

    public static Question newQuestionWithOperators(Map<String, Float> fields, String question) {
        Question q = new Question(fields, question, true);
        q.compute();
        return q;
    }

    public static Question newQuestionWithOperators(Map<String, Float> fields, String question, Analyzer analyzer) {
        return Question.newQuestionWithOperators(fields, question, analyzer, null);
    }

    public static Question newQuestionWithOperators(Map<String, Float> fields, String question, Analyzer analyzer, Catalog catalog) {
        Question q = new Question(fields, question, true);
        q.compute(analyzer, catalog);
        return q;
    }
}

