/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.pageseeder.flint.lucene.facet.FlexibleRangeFacet;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class StringRangeFacet
extends FlexibleRangeFacet {
    private final List<FlexibleRangeFacet.Range> _ranges = new ArrayList<FlexibleRangeFacet.Range>();
    private final boolean _caseSensitive;

    private StringRangeFacet(String name, boolean caseSensitive, List<FlexibleRangeFacet.Range> ranges) {
        super(name);
        this._ranges.addAll(ranges);
        this._caseSensitive = caseSensitive;
    }

    @Override
    protected String getType() {
        return "string-range";
    }

    @Override
    protected FlexibleRangeFacet.Range findRange(Term t) {
        if (t == null) {
            return null;
        }
        String word = t.text();
        for (FlexibleRangeFacet.Range r : this._ranges) {
            boolean passMax;
            boolean passMin;
            int compareMax;
            int compareMin;
            int n = r.getMin() == null ? 1 : (compareMin = this._caseSensitive ? word.compareToIgnoreCase(r.getMin()) : word.compareTo(r.getMin()));
            int n2 = r.getMax() == null ? -1 : (compareMax = this._caseSensitive ? word.compareToIgnoreCase(r.getMax()) : word.compareTo(r.getMax()));
            boolean bl = r.includeMin() ? compareMin >= 0 : (passMin = compareMin > 0);
            boolean bl2 = r.includeMax() ? compareMax <= 0 : (passMax = compareMax < 0);
            if (!passMin || !passMax) continue;
            return r;
        }
        return null;
    }

    @Override
    protected void rangeToXML(FlexibleRangeFacet.Range range, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("range");
        if (range.getMin() != null) {
            xml.attribute("min", range.getMin());
        }
        if (range.getMax() != null) {
            xml.attribute("max", range.getMax());
        }
        if (range.getMin() != null) {
            xml.attribute("include-min", range.includeMin() ? "true" : "false");
        }
        if (range.getMax() != null) {
            xml.attribute("include-max", range.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static class Builder {
        private final List<FlexibleRangeFacet.Range> ranges = new ArrayList<FlexibleRangeFacet.Range>();
        private boolean caseSensitive = false;
        private String name = null;

        public Builder caseSensitive(boolean cs) {
            this.caseSensitive = cs;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder addRange(String min, boolean withMin, String max, boolean withMax) {
            this.ranges.add(FlexibleRangeFacet.Range.stringRange(min, withMin, max, withMax));
            return this;
        }

        public Builder addRange(FlexibleRangeFacet.Range range) {
            this.ranges.add(range);
            return this;
        }

        public Builder addRange(String min, String max) {
            return this.addRange(min, true, max, true);
        }

        public StringRangeFacet build() {
            if (this.name == null) {
                throw new NullPointerException("Must have a field name");
            }
            StringRangeFacet fr = new StringRangeFacet(this.name, this.caseSensitive, this.ranges);
            return fr;
        }
    }
}

