/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleFieldFacet;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class StringFieldFacet
extends FlexibleFieldFacet {
    private StringFieldFacet(String name, int maxterms) {
        super(name, maxterms);
    }

    @Override
    protected Query termToQuery(Term t) {
        return new TermQuery(t);
    }

    @Override
    protected String getType() {
        return "string-field";
    }

    @Override
    protected void termToXML(String term, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("term");
        xml.attribute("text", term);
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    public static StringFieldFacet newFacet(String field) {
        return new StringFieldFacet(field, -1);
    }

    public static StringFieldFacet newFacet(String field, int maxValues) {
        return new StringFieldFacet(field, maxValues);
    }
}

