/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class StringIntervalFacet
extends FlexibleIntervalFacet {
    private final String _intervalLength;
    private final boolean _includeMin;
    private final boolean _includeMax;
    private final boolean _caseSensitive;

    private StringIntervalFacet(String name, String start, int maxIntervals, boolean caseSensitive, String length, boolean includeMin, boolean includeMax) {
        super(name, start, maxIntervals);
        this._intervalLength = length;
        this._includeMin = includeMin;
        this._includeMax = includeMax;
        this._caseSensitive = caseSensitive;
    }

    @Override
    protected Query termToQuery(Term t) {
        return new TermQuery(t);
    }

    @Override
    protected String getType() {
        return "string-interval";
    }

    @Override
    protected FlexibleIntervalFacet.Interval findInterval(Term t) {
        if (t == null) {
            return null;
        }
        String termValue = t.text();
        if (termValue.isEmpty()) {
            return null;
        }
        boolean forward = this.isAfter(termValue, this.start());
        String from = this.start();
        while (true) {
            String to = StringIntervalFacet.next(from, this._intervalLength, forward);
            String lower = forward ? from : to;
            String upper = forward ? to : from;
            boolean lowerLimit = this.isAfter(termValue, lower);
            boolean upperLimit = this.isBefore(termValue, upper);
            if (lowerLimit && upperLimit) {
                return FlexibleIntervalFacet.Interval.stringInterval(lower, this._includeMin, upper, this._includeMax);
            }
            if (forward && upperLimit) {
                return null;
            }
            if (!forward && lowerLimit) {
                return null;
            }
            if (from.equals(to)) {
                return null;
            }
            from = to;
        }
    }

    @Override
    protected void intervalToXML(FlexibleIntervalFacet.Interval interval, int cardinality, XMLWriter xml) throws IOException {
        xml.openElement("interval");
        if (interval.getMin() != null) {
            xml.attribute("min", interval.getMin());
        }
        if (interval.getMax() != null) {
            xml.attribute("max", interval.getMax());
        }
        if (interval.getMin() != null) {
            xml.attribute("include-min", interval.includeMin() ? "true" : "false");
        }
        if (interval.getMax() != null) {
            xml.attribute("include-max", interval.includeMax() ? "true" : "false");
        }
        xml.attribute("cardinality", cardinality);
        xml.closeElement();
    }

    private boolean isAfter(String s1, String s2) {
        int comparison = this._caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        return comparison > 0 || this._includeMin && comparison == 0;
    }

    private boolean isBefore(String s1, String s2) {
        int comparison = this._caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        return comparison < 0 || this._includeMax && comparison == 0;
    }

    private static String next(String s, String interval, boolean increase) {
        StringBuilder increased = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (i < interval.length()) {
                char ic = interval.toLowerCase().charAt(i);
                if ((c = (char)(c + (ic - 97 + 1) * (increase ? 1 : -1))) < 48) {
                    c = 32;
                }
                if (c > 57 && c < 65) {
                    int n = c = increase ? 65 : 57;
                }
                if (c > 90 && c < 97) {
                    int n = c = increase ? 97 : 90;
                }
                if (c > 122) {
                    c = 126;
                }
            }
            increased.append((char)c);
        }
        return increased.toString();
    }

    public static class Builder {
        private String intervalLength = null;
        private String start = null;
        private boolean includeMin = true;
        private boolean includeMax = false;
        private boolean caseSensitive = true;
        private String name = null;
        private int maxIntervals = -1;

        public Builder caseSensitive(boolean cs) {
            this.caseSensitive = cs;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder includeMax(boolean include) {
            this.includeMax = include;
            return this;
        }

        public Builder includeMin(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder intervalLength(String length) {
            this.intervalLength = length;
            return this;
        }

        public Builder start(String thestart) {
            this.start = thestart;
            return this;
        }

        public Builder maxIntervals(int max) {
            this.maxIntervals = max;
            return this;
        }

        public StringIntervalFacet build() {
            if (this.name == null) {
                throw new NullPointerException("Must have a field name");
            }
            if (this.start == null) {
                throw new NullPointerException("Must have a start date");
            }
            if (this.intervalLength == null) {
                throw new NullPointerException("Must have an interval length");
            }
            return new StringIntervalFacet(this.name, this.start, this.maxIntervals, this.caseSensitive, this.intervalLength, this.includeMin, this.includeMax);
        }
    }
}

