/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class SuggestionQuery
implements SearchQuery {
    private final List<Term> _terms;
    private final Query _condition;
    private BooleanQuery query = null;

    public SuggestionQuery(List<Term> terms) {
        this(terms, null);
    }

    public SuggestionQuery(List<Term> terms, Query condition) {
        this._terms = terms;
        this._condition = condition;
    }

    public void compute(IndexReader reader) throws IOException {
        List<Term> terms = new ArrayList<Term>();
        for (Term term : this._terms) {
            terms.add(term);
            List<String> values = Terms.prefix(reader, term);
            for (String v : values) {
                Term t = new Term(term.field(), v);
                if (terms.contains(t)) continue;
                terms.add(t);
            }
        }
        if (terms.size() >= BooleanQuery.getMaxClauseCount()) {
            terms = terms.subList(0, BooleanQuery.getMaxClauseCount() - 1);
        }
        BooleanQuery bq = new BooleanQuery();
        for (Term t : terms) {
            TermQuery q = new TermQuery(t);
            bq.add((Query)q, BooleanClause.Occur.SHOULD);
        }
        if (this._condition != null) {
            this.query = new BooleanQuery();
            this.query.add(this._condition, BooleanClause.Occur.MUST);
            this.query.add((Query)bq, BooleanClause.Occur.MUST);
        } else {
            this.query = bq;
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("suggestion-query");
        xml.openElement("terms");
        for (Term t : this._terms) {
            xml.openElement("term");
            xml.attribute("field", t.field());
            xml.attribute("text", t.text());
            xml.closeElement();
        }
        xml.closeElement();
        if (this._condition != null) {
            xml.openElement("condition");
            xml.writeText(this._condition.toString());
            xml.closeElement();
        }
        xml.closeElement();
    }

    @Override
    public Query toQuery() {
        return this.query;
    }

    @Override
    public boolean isEmpty() {
        return this._terms.isEmpty();
    }

    @Override
    public Sort getSort() {
        return Sort.RELEVANCE;
    }
}

