/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.NumberParameter;
import org.pageseeder.flint.lucene.query.Queries;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class TermFilter
implements Filter {
    private final String _name;
    private FlintField.NumericType _numeric = null;
    private final Map<String, BooleanClause.Occur> _terms = new HashMap<String, BooleanClause.Occur>();

    private TermFilter(Builder builder) {
        this._name = builder._name;
        this._numeric = builder._numeric;
        this._terms.putAll(builder._terms);
    }

    @Override
    public Query filterQuery(Query base) {
        BooleanQuery filterQuery = new BooleanQuery();
        for (String word : this._terms.keySet()) {
            BooleanClause.Occur clause = this._terms.get(word);
            filterQuery.add(this.wordToQuery(word), clause);
        }
        return base == null ? filterQuery : Queries.and(new Query[]{base, filterQuery});
    }

    @Override
    public String name() {
        return this._name;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("filter");
        xml.attribute("field", this._name);
        for (String word : this._terms.keySet()) {
            xml.openElement("term");
            xml.attribute("text", word);
            xml.attribute("occur", TermFilter.occurToString(this._terms.get(word)));
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static TermFilter newTermFilter(String name, String word) {
        return TermFilter.newTermFilter(name, word, BooleanClause.Occur.MUST);
    }

    public static TermFilter newTermFilter(String name, String word, BooleanClause.Occur occur) {
        return new Builder().name(name).addTerm(word, occur).build();
    }

    private Query wordToQuery(String word) {
        if (this._numeric != null) {
            switch (this._numeric) {
                case INT: {
                    return NumberParameter.newIntParameter(this._name, Integer.parseInt(word)).toQuery();
                }
                case LONG: {
                    return NumberParameter.newLongParameter(this._name, Long.parseLong(word)).toQuery();
                }
                case DOUBLE: {
                    return NumberParameter.newDoubleParameter(this._name, NumericUtils.sortableLongToDouble((long)Long.parseLong(word))).toQuery();
                }
                case FLOAT: {
                    return NumberParameter.newFloatParameter(this._name, Float.valueOf(NumericUtils.sortableIntToFloat((int)Integer.parseInt(word)))).toQuery();
                }
            }
        }
        return new TermQuery(new Term(this._name, word));
    }

    private static String occurToString(BooleanClause.Occur occur) {
        if (occur == BooleanClause.Occur.MUST) {
            return "must";
        }
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return "must_not";
        }
        if (occur == BooleanClause.Occur.SHOULD) {
            return "should";
        }
        return "unknown";
    }

    public static class Builder {
        private String _name = null;
        private FlintField.NumericType _numeric = null;
        private final Map<String, BooleanClause.Occur> _terms = new HashMap<String, BooleanClause.Occur>();

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        public Builder numeric(FlintField.NumericType numeric) {
            this._numeric = numeric;
            return this;
        }

        public Builder addTerm(String term, BooleanClause.Occur when) {
            this._terms.put(term, when == null ? BooleanClause.Occur.MUST : when);
            return this;
        }

        public TermFilter build() {
            if (this._name == null) {
                throw new NullPointerException("name");
            }
            if (this._terms.isEmpty()) {
                throw new IllegalStateException("no terms to filter with!");
            }
            return new TermFilter(this);
        }
    }
}

