/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.NumberParameter;
import org.pageseeder.flint.lucene.search.DocumentCounter;
import org.pageseeder.flint.lucene.search.Facet;
import org.pageseeder.flint.lucene.search.Filter;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Bucket;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class FlexibleFieldFacet
implements XMLWritable,
Facet {
    public static final int DEFAULT_MAX_NUMBER_OF_VALUES = 10;
    private final String _name;
    private final int _maxTerms;
    private final FlintField.NumericType _numeric;
    private transient Bucket<Term> _bucket;
    private transient boolean flexible = false;
    private transient int totalResults = 0;
    private transient int totalTerms = 0;

    private FlexibleFieldFacet(String name, FlintField.NumericType numeric, int maxterms) {
        this._name = name;
        this._numeric = numeric;
        this._maxTerms = maxterms;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public Query forValue(String value) {
        if (value == null) {
            return null;
        }
        return new TermQuery(new Term(this._name, value));
    }

    public void compute(IndexSearcher searcher, Query base, List<Filter> filters, int size) throws IOException {
        if (base == null) {
            this.compute(searcher, size);
        } else {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.totalTerms = 0;
            List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
            if (this._maxTerms > 0 && terms.size() > this._maxTerms) {
                return;
            }
            Query filtered = base;
            if (filters != null) {
                this.flexible = true;
                for (Filter filter : filters) {
                    if (this._name.equals(filter.name())) continue;
                    filtered = filter.filterQuery(filtered);
                }
            }
            Bucket<Term> bucket = new Bucket<Term>(size);
            DocumentCounter counter = new DocumentCounter();
            for (Term t : terms) {
                BooleanQuery query = new BooleanQuery();
                query.add(filtered, BooleanClause.Occur.MUST);
                query.add(this.termToQuery(t), BooleanClause.Occur.MUST);
                searcher.search((Query)query, (Collector)counter);
                int count = counter.getCount();
                bucket.add(t, count);
                counter.reset();
                if (count <= 0) continue;
                ++this.totalTerms;
            }
            this._bucket = bucket;
            BooleanQuery query = new BooleanQuery();
            query.add(base, BooleanClause.Occur.MUST);
            query.add((Query)new FieldValueQuery(this._name), BooleanClause.Occur.MUST);
            searcher.search((Query)query, (Collector)counter);
            this.totalResults = counter.getCount();
        }
    }

    public void compute(IndexSearcher searcher, Query base, int size) throws IOException {
        this.compute(searcher, base, null, size);
    }

    @Override
    public void compute(IndexSearcher searcher, Query base) throws IOException {
        this.compute(searcher, base, null, 10);
    }

    @Override
    public void compute(IndexSearcher searcher, Query base, List<Filter> filters) throws IOException {
        this.compute(searcher, base, filters, 10);
    }

    private void compute(IndexSearcher searcher, int size) throws IOException {
        List<Term> terms = Terms.terms(searcher.getIndexReader(), this._name);
        if (this._maxTerms > 0 && terms.size() > this._maxTerms) {
            return;
        }
        Bucket<Term> bucket = new Bucket<Term>(size);
        DocumentCounter counter = new DocumentCounter();
        for (Term t : terms) {
            searcher.search(this.termToQuery(t), (Collector)counter);
            bucket.add(t, counter.getCount());
            counter.reset();
        }
        this.totalTerms = terms.size();
        this.totalResults = 0;
        this._bucket = bucket;
    }

    private Query termToQuery(Term t) {
        if (this._numeric != null) {
            switch (this._numeric) {
                case INT: {
                    return NumberParameter.newIntParameter(t.field(), NumericUtils.prefixCodedToInt((BytesRef)t.bytes())).toQuery();
                }
                case LONG: {
                    return NumberParameter.newLongParameter(t.field(), NumericUtils.prefixCodedToLong((BytesRef)t.bytes())).toQuery();
                }
                case DOUBLE: {
                    return NumberParameter.newDoubleParameter(t.field(), NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)t.bytes()))).toQuery();
                }
                case FLOAT: {
                    return NumberParameter.newFloatParameter(t.field(), Float.valueOf(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)t.bytes())))).toQuery();
                }
            }
        }
        return new TermQuery(t);
    }

    private String termToText(Term t) {
        if (this._numeric != null) {
            switch (this._numeric) {
                case INT: {
                    return String.valueOf(NumericUtils.prefixCodedToInt((BytesRef)t.bytes()));
                }
                case LONG: {
                    return String.valueOf(NumericUtils.prefixCodedToLong((BytesRef)t.bytes()));
                }
                case DOUBLE: {
                    return String.valueOf(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)t.bytes())));
                }
                case FLOAT: {
                    return String.valueOf(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)t.bytes())));
                }
            }
        }
        return t.text();
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("facet", true);
        xml.attribute("name", this._name);
        xml.attribute("type", this._numeric == null ? "field" : "numeric-field");
        xml.attribute("flexible", String.valueOf(this.flexible));
        if (!this.flexible) {
            xml.attribute("total-terms", this.totalTerms);
            xml.attribute("total-results", this.totalResults);
        }
        if (this._bucket != null) {
            for (Bucket.Entry<Term> e : this._bucket.entrySet()) {
                xml.openElement("term");
                xml.attribute("text", this.termToText(e.item()));
                xml.attribute("cardinality", e.count());
                xml.closeElement();
            }
        }
        xml.closeElement();
    }

    public Bucket<Term> getValues() {
        return this._bucket;
    }

    public static FlexibleFieldFacet newFacet(String field) throws IOException {
        return new FlexibleFieldFacet(field, null, -1);
    }

    public static FlexibleFieldFacet newFacet(String field, int maxValues) throws IOException {
        return new FlexibleFieldFacet(field, null, maxValues);
    }

    public static FlexibleFieldFacet newFacet(String field, FlintField.NumericType type) throws IOException {
        return new FlexibleFieldFacet(field, type, -1);
    }

    public static FlexibleFieldFacet newFacet(String field, FlintField.NumericType type, int maxValues) throws IOException {
        return new FlexibleFieldFacet(field, type, maxValues);
    }
}

