/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.OpenIndexManager;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.lucene.LuceneDeleteRule;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneIndexIO
implements IndexIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexIO.class);
    public static final String LAST_COMMIT_DATE = "lastCommitDate";
    private volatile State state = State.CLEAN;
    private final AtomicLong lastTimeUsed = new AtomicLong(0L);
    private final IndexWriter _writer;
    private ReaderManager _reader;
    private final SearcherManager _searcher;
    private static final SearcherFactory FACTORY = new SearcherFactory();

    public LuceneIndexIO(Directory dir, Analyzer analyzer) throws IndexException {
        try {
            boolean createIt = !DirectoryReader.indexExists((Directory)dir);
            boolean readonly = LuceneIndexIO.isReadOnly(dir);
            if (readonly && createIt) {
                throw new IndexException("Cannot create index location ", (Exception)new InvalidParameterException());
            }
            if (readonly) {
                this._writer = null;
                this._reader = new ReaderManager(dir);
                this._searcher = new SearcherManager(dir, FACTORY);
            } else {
                IndexWriterConfig config = new IndexWriterConfig(analyzer);
                ConcurrentMergeScheduler merger = new ConcurrentMergeScheduler();
                config.setMergeScheduler((MergeScheduler)merger);
                if (createIt) {
                    config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                }
                this._writer = new IndexWriter(dir, config);
                if (createIt) {
                    this._writer.commit();
                }
                boolean applyAllDeletes = true;
                this._searcher = new SearcherManager(this._writer, applyAllDeletes, FACTORY);
                this._reader = new ReaderManager(this._writer, applyAllDeletes);
            }
        }
        catch (IOException ex) {
            throw new IndexException("Failed to create writer on index", (Exception)ex);
        }
        try {
            String lastCommitDate;
            List commits = DirectoryReader.listCommits((Directory)dir);
            if (commits != null && !commits.isEmpty() && (lastCommitDate = (String)((IndexCommit)commits.get(commits.size() - 1)).getUserData().get(LAST_COMMIT_DATE)) != null) {
                this.lastTimeUsed.set(Long.parseLong(lastCommitDate));
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load last index commit date", (Throwable)ex);
        }
        OpenIndexManager.add((IndexIO)this);
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed.get();
    }

    public synchronized void stop() throws IndexException {
        if (this._writer == null || this.state == State.CLOSED) {
            return;
        }
        LOGGER.debug("Stopping IO");
        this.maybeCommit();
        try {
            this._writer.close();
            this._searcher.close();
            this._reader.close();
            this.state = State.CLOSED;
            OpenIndexManager.remove((IndexIO)this);
        }
        catch (CorruptIndexException ex) {
            throw new IndexException("Failed to close Index because it is corrupted", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new IndexException("Failed to close Index because of an I/O error", (Exception)ex);
        }
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public synchronized void maybeRefresh() {
        if (this._writer == null || this.state != State.DIRTY) {
            return;
        }
        try {
            LOGGER.debug("Reopen reader and searcher");
            this._reader.maybeRefresh();
            this._searcher.maybeRefresh();
            this.state = State.CLEAN;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to reopen Index Searcher because of an I/O error", (Throwable)ex);
        }
    }

    public synchronized void maybeCommit() {
        if (this._writer == null || !this._writer.hasDeletions() && !this._writer.hasUncommittedChanges() && !this._writer.hasPendingMerges()) {
            return;
        }
        this.maybeRefresh();
        try {
            LOGGER.debug("Committing index changes");
            long now = System.currentTimeMillis();
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            commitUserData.put(LAST_COMMIT_DATE, String.valueOf(now));
            this._writer.setCommitData(commitUserData);
            this._writer.commit();
            this.lastTimeUsed.set(now);
        }
        catch (CorruptIndexException ex) {
            LOGGER.error("Failed to commit Index because it is corrupted", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to commit Index because of an I/O error", (Throwable)ex);
        }
    }

    public synchronized boolean clearIndex() throws IndexException {
        if (this._writer == null) {
            return true;
        }
        if (this.state == State.CLOSED) {
            return false;
        }
        try {
            this._writer.deleteAll();
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state = State.DIRTY;
        }
        catch (IOException ex) {
            throw new IndexException("Failed to clear Index", (Exception)ex);
        }
        return true;
    }

    public synchronized boolean deleteDocuments(DeleteRule rule) throws IndexException {
        if (this._writer == null) {
            return true;
        }
        if (this.state == State.CLOSED) {
            return false;
        }
        if (!(rule instanceof LuceneDeleteRule)) {
            return false;
        }
        LuceneDeleteRule drule = (LuceneDeleteRule)rule;
        try {
            if (drule.useTerm()) {
                this._writer.deleteDocuments(new Term[]{drule.toTerm()});
            } else {
                this._writer.deleteDocuments(new Query[]{drule.toQuery()});
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state = State.DIRTY;
        }
        catch (IOException ex) {
            throw new IndexException("Failed to clear Index", (Exception)ex);
        }
        return true;
    }

    public synchronized boolean updateDocuments(DeleteRule rule, List<FlintDocument> documents) throws IndexException {
        LuceneDeleteRule drule;
        if (this._writer == null) {
            return true;
        }
        if (this.state == State.CLOSED) {
            return false;
        }
        if (rule == null) {
            drule = null;
        } else {
            if (!(rule instanceof LuceneDeleteRule)) {
                return false;
            }
            drule = (LuceneDeleteRule)rule;
        }
        try {
            List<Document> docs = LuceneUtils.toDocuments(documents);
            if (rule != null) {
                if (drule.useTerm()) {
                    this._writer.updateDocuments(drule.toTerm(), docs);
                } else {
                    this._writer.deleteDocuments(new Query[]{drule.toQuery()});
                    this._writer.addDocuments(docs);
                }
            } else {
                this._writer.addDocuments(docs);
            }
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state = State.DIRTY;
        }
        catch (IOException e) {
            throw new IndexException("Failed to update document in Index because of an I/O error", (Exception)e);
        }
        return true;
    }

    public synchronized boolean updateDocValues(Term term, Field ... newFields) throws IndexException {
        if (this._writer == null) {
            return true;
        }
        if (this.state == State.CLOSED) {
            return false;
        }
        try {
            this._writer.updateDocValues(term, newFields);
            this.lastTimeUsed.set(System.currentTimeMillis());
            this.state = State.DIRTY;
        }
        catch (IOException ex) {
            throw new IndexException("Failed to update docvalues in Index because of an I/O error", (Exception)ex);
        }
        return true;
    }

    public IndexSearcher bookSearcher() {
        if (this.state == State.CLOSED) {
            return null;
        }
        try {
            return (IndexSearcher)this._searcher.acquire();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to book searcher", (Throwable)ex);
            return null;
        }
    }

    public void releaseSearcher(IndexSearcher searcher) {
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            this._searcher.release((Object)searcher);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release searcher", (Throwable)ex);
        }
    }

    public IndexReader bookReader() {
        if (this.state == State.CLOSED) {
            return null;
        }
        try {
            return (IndexReader)this._reader.acquire();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to book reader", (Throwable)ex);
            return null;
        }
    }

    public void releaseReader(IndexReader reader) {
        if (this.state == State.CLOSED) {
            return;
        }
        if (!(reader instanceof DirectoryReader)) {
            throw new IllegalArgumentException("Reader must be a DirectoryReader");
        }
        try {
            this._reader.release((Object)((DirectoryReader)reader));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to release reader", (Throwable)ex);
        }
    }

    private static boolean isReadOnly(Directory directory) {
        if (!(directory instanceof FSDirectory)) {
            return false;
        }
        try {
            File f = ((FSDirectory)directory).getDirectory().toFile();
            if (!f.canWrite()) {
                return true;
            }
            for (File tf : f.listFiles()) {
                if (tf.canWrite()) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Index is readonly", (Throwable)ex);
            return true;
        }
        return false;
    }

    private static enum State {
        CLEAN,
        DIRTY,
        CLOSED;

    }
}

