/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.util;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.search.Terms;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.esc.XMLEscapeUTF8;

public final class Documents {
    private Documents() {
    }

    @Beta
    public static void toXML(XMLWriter xml, Document doc, List<Terms> terms, int extractLength) throws IOException {
        xml.openElement("document", true);
        for (IndexableField f : doc.getFields()) {
            String value = Fields.toString(f);
            if (value == null || value.length() >= 100) continue;
            xml.openElement("field");
            xml.attribute("name", f.name());
            xml.writeText(value);
            xml.closeElement();
        }
        xml.closeElement();
    }

    @Beta
    public static void toXML(XMLWriter xml, Document doc) throws IOException {
        xml.openElement("document", true);
        for (IndexableField f : doc.getFields()) {
            String value = Fields.toString(f);
            if (value == null || value.length() >= 100) continue;
            xml.openElement("field");
            xml.attribute("name", f.name());
            xml.writeText(value);
            xml.closeElement();
        }
        xml.closeElement();
    }

    @Beta
    public static String extract(String text, String term, int length) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        if (term.length() > length) {
            throw new IllegalArgumentException("Term length (" + term.length() + ") is larger than extract length (" + length + ")");
        }
        int len = length - term.length();
        Pattern p = Pattern.compile("(?:\\W|^)(\\Q" + term + "\\E)(?:\\W|$)", 2);
        Matcher m = p.matcher(text);
        if (m.find()) {
            StringBuilder extract = new StringBuilder();
            int start = m.start(1);
            int end = m.end(1);
            if (length > text.length()) {
                extract.append(Documents.asXML(text.substring(0, start)));
                extract.append("<term>").append(Documents.asXML(m.group(1))).append("</term>");
                extract.append(Documents.asXML(text.substring(end)));
            } else if (start < len / 2) {
                extract.append(Documents.asXML(text.substring(0, start)));
                extract.append("<term>").append(Documents.asXML(m.group(1))).append("</term>");
                if (text.length() - end < len - start) {
                    extract.append(Documents.asXML(text.substring(end)));
                } else {
                    extract.append(Documents.asXML(text.substring(end, end + len - start - 1))).append("...");
                }
            } else if (text.length() - end < len / 2) {
                int x = text.length() - end;
                if (x > start) {
                    extract.append(Documents.asXML(text.substring(0, start)));
                } else {
                    extract.append("...").append(Documents.asXML(text.substring(start - x, start)));
                }
                extract.append("<term>").append(Documents.asXML(m.group(1))).append("</term>");
                extract.append(Documents.asXML(text.substring(end)));
            } else {
                extract.append("...").append(Documents.asXML(text.substring(start - len / 2, start)));
                extract.append("<term>").append(Documents.asXML(m.group(1))).append("</term>");
                extract.append(Documents.asXML(text.substring(end, end + len / 2))).append("...");
            }
            return extract.toString();
        }
        return null;
    }

    private static String asXML(String text) {
        return XMLEscapeUTF8.UTF8_ESCAPE.toElementText(text);
    }
}

