/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.pageseeder.flint.lucene.util.Beta;

@Beta
public final class Bucket<T>
implements Iterable<T> {
    private final int _capacity;
    private final SortedSet<Entry<T>> _entries;
    private final boolean _acceptZero;
    private transient int minCount = 1;
    private int _considered = 0;

    public Bucket(int capacity) throws IllegalArgumentException {
        this._capacity = capacity;
        this._entries = new TreeSet<Entry<T>>();
        this._acceptZero = false;
    }

    public Bucket(int capacity, boolean acceptZero) throws IllegalArgumentException {
        this._capacity = capacity;
        this._entries = new TreeSet<Entry<T>>();
        if (acceptZero) {
            this.minCount = 0;
        }
        this._acceptZero = acceptZero;
    }

    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    public boolean isFull() {
        return this._entries.size() == this._capacity;
    }

    public void add(T item, int count) {
        if (count > 0 || this._acceptZero) {
            ++this._considered;
        }
        if (count >= this.minCount) {
            this._entries.add(new Entry<T>(item, count));
            if (this._entries.size() > this._capacity) {
                this._entries.remove(this._entries.last());
                this.minCount = this._entries.last().count();
            }
        }
    }

    public int count(T item) {
        for (Entry entry : this._entries) {
            if (!entry._item.equals(item)) continue;
            return entry.count();
        }
        return 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items().iterator();
    }

    public Set<Entry<T>> entrySet() {
        return Collections.unmodifiableSet(this._entries);
    }

    public List<T> items() {
        ArrayList items = new ArrayList(this._entries.size());
        for (Entry entry : this._entries) {
            items.add(entry.item());
        }
        return items;
    }

    public int capacity() {
        return this._capacity;
    }

    public int getConsidered() {
        return this._considered;
    }

    public static final class Entry<T>
    implements Comparable<Entry<T>> {
        private final T _item;
        private final int _count;

        public Entry(T item, int count) {
            this._item = item;
            this._count = count;
        }

        public T item() {
            return this._item;
        }

        public int count() {
            return this._count;
        }

        public int hashCode() {
            return this._count * 19 + this._item.hashCode() + 11;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                return this.equals((Entry)o);
            }
            return false;
        }

        public boolean equals(Entry<?> o) {
            if (this._count != o._count) {
                return false;
            }
            return Entry.comparable(this._item, o._item) ? this._item.equals(o._item) : true;
        }

        @Override
        public int compareTo(Entry<T> e) {
            int c = e._count - this._count;
            if (c != 0) {
                return c;
            }
            return Entry.comparable(this._item, e._item) ? ((Comparable)this._item).compareTo(e._item) : 0;
        }

        public String toString() {
            return this._item.toString() + ':' + this._count;
        }

        private static boolean comparable(Object o1, Object o2) {
            return o1 instanceof Comparable && o2 instanceof Comparable;
        }
    }
}

