/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.util.Dates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneUtils.class);

    public static List<Document> toDocuments(List<FlintDocument> fdocs) {
        ArrayList<Document> docs = new ArrayList<Document>();
        for (FlintDocument fdoc : fdocs) {
            Document doc = new Document();
            for (FlintField field : fdoc.fields()) {
                IndexableField thefield = LuceneUtils.toField(field);
                if (thefield != null) {
                    doc.add(thefield);
                    continue;
                }
                LOGGER.warn("Ignoring invalid field {}", (Object)field.name());
            }
            docs.add(doc);
        }
        return docs;
    }

    public static IndexableField toField(FlintField ffield) {
        if (ffield.name() == null) {
            throw new IllegalStateException("Unable to build field, field name not set");
        }
        if (ffield.index() == null) {
            throw new IllegalStateException("Unable to build field, field index not set");
        }
        if (ffield.value() == null) {
            throw new IllegalStateException("Unable to build field, field value not set");
        }
        if (ffield.compressed()) {
            return LuceneUtils.toCompressedField(ffield);
        }
        if (ffield.isDocValues()) {
            return LuceneUtils.toDocValuesField(ffield);
        }
        return LuceneUtils.toNormalField(ffield);
    }

    public static DateTools.Resolution toResolution(FlintField.Resolution resolution) {
        if (resolution == null) {
            return null;
        }
        switch (resolution) {
            case DAY: {
                return DateTools.Resolution.DAY;
            }
            case HOUR: {
                return DateTools.Resolution.HOUR;
            }
            case MILLISECOND: {
                return DateTools.Resolution.MILLISECOND;
            }
            case MINUTE: {
                return DateTools.Resolution.MINUTE;
            }
            case MONTH: {
                return DateTools.Resolution.MONTH;
            }
            case SECOND: {
                return DateTools.Resolution.SECOND;
            }
            case YEAR: {
                return DateTools.Resolution.YEAR;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IndexableField toNormalField(FlintField ffield) {
        Field field;
        block17: {
            String value;
            FieldType type;
            block18: {
                block19: {
                    type = new FieldType();
                    type.setStored(ffield.store());
                    type.setTokenized(ffield.tokenize());
                    type.setIndexOptions(LuceneUtils.toIndexOptions(ffield.index()));
                    if (ffield.index() != FlintField.IndexOptions.NONE) {
                        type.setOmitNorms(ffield.omitNorms());
                        type.setStoreTermVectors(ffield.termVector());
                        type.setStoreTermVectorOffsets(ffield.termVectorOffsets());
                        type.setStoreTermVectorPositions(ffield.termVectorPositions());
                        type.setStoreTermVectorPayloads(ffield.termVectorPayloads());
                    }
                    value = ffield.value().toString();
                    field = null;
                    if (ffield.numeric() == null) break block18;
                    type.setNumericType(LuceneUtils.toNumericType(ffield.numeric()));
                    if (ffield.dateformat() == null) break block19;
                    Number date = Dates.toNumber(LuceneUtils.toDate(value, ffield.dateformat()), LuceneUtils.toResolution(ffield.resolution()));
                    if (date != null && date instanceof Long) {
                        field = new LongField(ffield.name(), ((Long)date).longValue(), type);
                        type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 16);
                        break block17;
                    } else if (date != null && date instanceof Integer) {
                        field = new IntField(ffield.name(), ((Integer)date).intValue(), type);
                        type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 8);
                        break block17;
                    } else {
                        LOGGER.warn("Ignoring field {} as it has a date format but no date", (Object)ffield.name());
                        return null;
                    }
                }
                try {
                    switch (ffield.numeric()) {
                        case FLOAT: {
                            type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 8);
                            field = new FloatField(ffield.name(), Float.parseFloat(value), type);
                            break;
                        }
                        case DOUBLE: {
                            type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 16);
                            field = new DoubleField(ffield.name(), Double.parseDouble(value), type);
                            break;
                        }
                        case INT: {
                            type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 8);
                            field = new IntField(ffield.name(), Integer.parseInt(value), type);
                            break;
                        }
                        case LONG: {
                            type.setNumericPrecisionStep(ffield.precisionStep() != null ? ffield.precisionStep() : 16);
                            field = new LongField(ffield.name(), Long.parseLong(value), type);
                            break;
                        }
                    }
                    break block17;
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Number field {} with invalid value {} will be stored as a String", (Object)ffield.name(), (Object)value);
                }
                break block17;
            }
            if (ffield.dateformat() != null) {
                Date date = LuceneUtils.toDate(value, ffield.dateformat());
                field = new Field(ffield.name(), date != null ? Dates.toString(date, LuceneUtils.toResolution(ffield.resolution())) : "", type);
            } else {
                field = new Field(ffield.name(), value, type);
            }
        }
        if (ffield.boost() != 1.0f) {
            field.setBoost(ffield.boost());
        }
        if (ffield.catalog() != null) {
            Catalogs.newField((String)ffield.catalog(), (FlintField)ffield);
        }
        return field;
    }

    private static IndexableField toDocValuesField(FlintField ffield) {
        SortedSetDocValuesField field = null;
        switch (ffield.docValues()) {
            case FORCED_NONE: {
                return null;
            }
            case SORTED_SET: {
                field = new SortedSetDocValuesField(ffield.name(), new BytesRef(ffield.value()));
                break;
            }
            case SORTED_NUMERIC: {
                if (ffield.numeric() == null) break;
                switch (ffield.numeric()) {
                    case DOUBLE: {
                        field = new SortedNumericDocValuesField(ffield.name(), NumericUtils.doubleToSortableLong((double)Double.parseDouble(ffield.value().toString())));
                    }
                    case FLOAT: {
                        field = new SortedNumericDocValuesField(ffield.name(), (long)NumericUtils.floatToSortableInt((float)Float.parseFloat(ffield.value().toString())));
                    }
                    case LONG: {
                        field = new SortedNumericDocValuesField(ffield.name(), Long.parseLong(ffield.value().toString()));
                    }
                    case INT: {
                        field = new SortedNumericDocValuesField(ffield.name(), (long)Integer.parseInt(ffield.value().toString()));
                    }
                }
                break;
            }
            case SORTED: {
                field = new SortedDocValuesField(ffield.name(), new BytesRef(ffield.value()));
                break;
            }
            default: {
                if (ffield.numeric() == null || ffield.dateformat() != null) break;
                switch (ffield.numeric()) {
                    case DOUBLE: {
                        field = new NumericDocValuesField(ffield.name(), NumericUtils.doubleToSortableLong((double)Double.parseDouble(ffield.value().toString())));
                    }
                    case FLOAT: {
                        field = new NumericDocValuesField(ffield.name(), (long)NumericUtils.floatToSortableInt((float)Float.parseFloat(ffield.value().toString())));
                    }
                    case LONG: {
                        field = new NumericDocValuesField(ffield.name(), Long.parseLong(ffield.value().toString()));
                    }
                    case INT: {
                        field = new NumericDocValuesField(ffield.name(), (long)Integer.parseInt(ffield.value().toString()));
                    }
                }
            }
        }
        if (field == null) {
            return null;
        }
        if (ffield.boost() != 1.0f) {
            field.setBoost(ffield.boost());
        }
        return field;
    }

    private static IndexableField toCompressedField(FlintField ffield) {
        byte[] value = CompressionTools.compressString((String)ffield.value().toString());
        FieldType type = new FieldType();
        type.setStored(true);
        Field field = new Field(ffield.name(), value, type);
        if (ffield.boost() != 1.0f) {
            field.setBoost(ffield.boost());
        }
        return field;
    }

    private static IndexOptions toIndexOptions(FlintField.IndexOptions options) {
        if (options == null) {
            return null;
        }
        switch (options) {
            case NONE: {
                return IndexOptions.NONE;
            }
            case DOCS: {
                return IndexOptions.DOCS;
            }
            case DOCS_AND_FREQS: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        return null;
    }

    private static FieldType.NumericType toNumericType(FlintField.NumericType numeric) {
        if (numeric == null) {
            return null;
        }
        switch (numeric) {
            case INT: {
                return FieldType.NumericType.INT;
            }
            case FLOAT: {
                return FieldType.NumericType.FLOAT;
            }
            case DOUBLE: {
                return FieldType.NumericType.DOUBLE;
            }
            case LONG: {
                return FieldType.NumericType.LONG;
            }
        }
        return null;
    }

    private static Date toDate(String value, DateFormat format) {
        try {
            return format.parse(value.toString());
        }
        catch (ParseException ex) {
            LOGGER.error("Ignoring unparsable date '{}' with format={}", (Object)value, (Object)format);
            return null;
        }
    }
}

