/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.pageseeder.diffx.token.ElementToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.XMLElement;
import org.pageseeder.diffx.xml.Sequence;

public class SequenceFolding {
    public static final List<String> ALL = Collections.singletonList("*");
    public final List<String> elements;

    public SequenceFolding(List<String> elements) {
        this.elements = elements;
    }

    public static SequenceFolding forElements(String ... elements) {
        List<String> list = Arrays.stream(elements).filter(i -> i != null && i.length() > 0).distinct().collect(Collectors.toList());
        return new SequenceFolding(list);
    }

    public static SequenceFolding forAllElements() {
        return new SequenceFolding(ALL);
    }

    public Sequence fold(Sequence input) {
        if (this.elements.isEmpty()) {
            return input;
        }
        FoldingProcessor processor = new FoldingProcessor();
        for (XMLToken token : input.tokens()) {
            processor.add(token);
        }
        return processor.sequence();
    }

    public List<? extends XMLToken> fold(List<? extends XMLToken> tokens) {
        if (this.elements.isEmpty()) {
            return tokens;
        }
        FoldingProcessor processor = new FoldingProcessor();
        for (XMLToken xMLToken : tokens) {
            processor.add(xMLToken);
        }
        return processor.tokens();
    }

    private boolean isFoldable(XMLToken token) {
        if (!(token instanceof StartElementToken)) {
            return false;
        }
        if (this.elements == ALL) {
            return true;
        }
        return this.elements.contains(token.getName());
    }

    private boolean isMatching(XMLToken token, StartElementToken open) {
        return token instanceof EndElementToken && ((EndElementToken)token).match(open);
    }

    private static class Folder {
        final StartElementToken open;
        private final List<XMLToken> children = new ArrayList<XMLToken>();

        Folder(StartElementToken open) {
            this.open = open;
        }

        void add(XMLToken token) {
            this.children.add(token);
        }

        ElementToken seal(EndElementToken close) {
            return new XMLElement(this.open, close, this.children);
        }
    }

    private class FoldingProcessor {
        private final List<XMLToken> tokens = new ArrayList<XMLToken>();
        private final List<Folder> stack = new ArrayList<Folder>();

        private FoldingProcessor() {
        }

        private Folder current() {
            return this.stack.get(this.stack.size() - 1);
        }

        private boolean hasCurrent() {
            return this.stack.size() > 0;
        }

        void add(XMLToken token) {
            if (SequenceFolding.this.isFoldable(token)) {
                Folder subfolder = new Folder((StartElementToken)token);
                this.stack.add(subfolder);
            } else if (this.stack.isEmpty()) {
                this.tokens.add(token);
            } else {
                Folder current = this.current();
                if (SequenceFolding.this.isMatching(token, current.open)) {
                    ElementToken element = current.seal((EndElementToken)token);
                    this.stack.remove(this.stack.size() - 1);
                    if (this.stack.isEmpty()) {
                        this.tokens.add(element);
                    } else {
                        this.current().add(element);
                    }
                } else {
                    current.add(token);
                }
            }
        }

        List<? extends XMLToken> tokens() {
            return this.tokens;
        }

        Sequence sequence() {
            return new Sequence(this.tokens);
        }
    }
}

