/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLAttribute
extends TokenBase
implements AttributeToken {
    private final String uri;
    private final String name;
    private final String value;
    private final int hashCode;

    public XMLAttribute(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
        this.uri = "";
        this.hashCode = XMLAttribute.toHashCode(this.uri, name, value);
    }

    public XMLAttribute(String uri, String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (value == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        if (uri == null) {
            throw new NullPointerException("The uri value cannot be null, use \"\".");
        }
        this.name = name;
        this.value = value;
        this.uri = uri;
        this.hashCode = XMLAttribute.toHashCode(uri, name, value);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.uri;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof AttributeToken)) {
            return false;
        }
        if (this.hashCode != token.hashCode()) {
            return false;
        }
        AttributeToken other = (AttributeToken)token;
        return this.name.equals(other.getName()) && this.value.equals(other.getValue()) && this.uri.equals(other.getNamespaceURI());
    }

    public String toString() {
        if (this.uri.isEmpty()) {
            return "@" + this.name + "=" + this.value;
        }
        return "@{" + this.uri + "}" + this.name + "=" + this.value;
    }

    @Override
    public void toXML(@NotNull XMLWriter xml) throws IOException {
        xml.attribute(this.uri, this.name, this.value);
    }

    @Override
    public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        if (this.uri.isEmpty()) {
            xml.writeAttribute(this.name, this.value);
        } else {
            xml.writeAttribute(this.uri, this.name, this.value);
        }
    }

    private static int toHashCode(String uri, String name, String value) {
        assert (uri != null);
        assert (name != null);
        assert (value != null);
        int hash = 17;
        hash = hash * 31 + uri.hashCode();
        hash = hash * 31 + name.hashCode();
        hash = hash * 31 + value.hashCode();
        return hash;
    }
}

