/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.impl.CharactersTokenBase;

public final class SpaceToken
extends CharactersTokenBase
implements TextToken {
    public static final SpaceToken SINGLE_WHITESPACE = new SpaceToken(" ");
    public static final SpaceToken DOUBLE_WHITESPACE = new SpaceToken("  ");
    public static final SpaceToken NEW_LINE = new SpaceToken("\n");
    public static final SpaceToken TAB = new SpaceToken("\t");

    public SpaceToken(CharSequence s) throws NullPointerException {
        super(s);
    }

    public String toString() {
        return "space: \"" + SpaceToken.toString(this.getCharacters().toCharArray()) + '\"';
    }

    public static SpaceToken getInstance(CharSequence space) {
        if (" ".contentEquals(space)) {
            return SINGLE_WHITESPACE;
        }
        if ("  ".contentEquals(space)) {
            return DOUBLE_WHITESPACE;
        }
        if ("\n".contentEquals(space)) {
            return NEW_LINE;
        }
        if ("\t".contentEquals(space)) {
            return TAB;
        }
        return new SpaceToken(space);
    }

    public static SpaceToken getInstance(char c) {
        if (c == ' ') {
            return SINGLE_WHITESPACE;
        }
        if (c == '\n') {
            return NEW_LINE;
        }
        if (c == '\t') {
            return TAB;
        }
        return new SpaceToken(String.valueOf(c));
    }

    private static String toString(char[] chars) {
        StringBuilder out = new StringBuilder();
        block4: for (char c : chars) {
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block4;
                }
                case '\t': {
                    out.append("\\t");
                    continue block4;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

