/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pageseeder.diffx.api.LoadingException;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.load.AttributeComparator;
import org.pageseeder.diffx.load.XMLLoader;
import org.pageseeder.diffx.load.XMLLoaderBase;
import org.pageseeder.diffx.load.text.TextTokenizer;
import org.pageseeder.diffx.load.text.TokenizerFactory;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLTokenFactory;
import org.pageseeder.diffx.token.impl.XMLComment;
import org.pageseeder.diffx.token.impl.XMLProcessingInstruction;
import org.pageseeder.diffx.xml.Sequence;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SAXLoader
extends XMLLoaderBase
implements XMLLoader {
    private static final String DEFAULT_XML_READER;
    private static String readerClassName;

    @Override
    public Sequence load(InputSource is) throws LoadingException, IOException {
        XMLReader reader = SAXLoader.newReader(this.config);
        Handler handler = new Handler(this.config);
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            reader.parse(is);
        }
        catch (SAXException ex) {
            throw new LoadingException(ex);
        }
        return handler.sequence;
    }

    public static String getXMLReaderClass() {
        return readerClassName;
    }

    public static void setXMLReaderClass(String className) {
        if (className == null) {
            className = DEFAULT_XML_READER;
        }
        readerClassName = className;
    }

    private static XMLReader newReader(DiffConfig config) throws LoadingException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader(readerClassName);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://xml.org/sax/features/namespaces", config.isNamespaceAware());
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", !config.isNamespaceAware());
            return reader;
        }
        catch (SAXException ex) {
            throw new LoadingException(ex);
        }
    }

    static {
        String className;
        try {
            className = XMLReaderFactory.createXMLReader().getClass().getName();
        }
        catch (SAXException ex) {
            System.err.println("org.pageseeder.diffx.SAXLoader cannot find a default XML loader!");
            className = "";
        }
        readerClassName = DEFAULT_XML_READER = className;
    }

    private static final class Handler
    extends DefaultHandler
    implements LexicalHandler {
        private Sequence sequence;
        private final StringBuilder ch = new StringBuilder();
        private final AttributeComparator comparator = new AttributeComparator();
        private final List<StartElementToken> openElements = new ArrayList<StartElementToken>();
        private final XMLTokenFactory tokenFactory;
        private final TextTokenizer tokenizer;

        Handler(DiffConfig config) {
            this.tokenFactory = new XMLTokenFactory(config.isNamespaceAware());
            this.tokenizer = TokenizerFactory.get(config);
        }

        public Sequence getSequence() {
            return this.sequence;
        }

        @Override
        public void startDocument() {
            this.sequence = new Sequence();
            this.sequence.addNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            this.sequence.addNamespace("", "");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.sequence.addNamespace(uri, prefix, this.openElements.isEmpty());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.recordCharacters();
            StartElementToken open = this.tokenFactory.newStartElement(uri, localName, qName);
            this.openElements.add(open);
            this.sequence.addToken(open);
            this.handleAttributes(attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.recordCharacters();
            StartElementToken open = this.popLastOpenElement();
            EndElementToken close = this.tokenFactory.newEndElement(open);
            this.sequence.addToken(close);
        }

        @Override
        public void characters(char[] buf, int pos, int len) {
            this.ch.append(buf, pos, len);
        }

        @Override
        public void ignorableWhitespace(char[] buf1, int pos, int len) {
        }

        @Override
        public void processingInstruction(String target, String data) {
            this.sequence.addToken(new XMLProcessingInstruction(target, data));
        }

        @Override
        public void endDocument() {
        }

        private void recordCharacters() {
            if (this.ch.length() > 0) {
                List<TextToken> tokens = this.tokenizer.tokenize(this.ch);
                for (TextToken token : tokens) {
                    this.sequence.addToken(token);
                }
                this.ch.setLength(0);
            }
        }

        private StartElementToken popLastOpenElement() {
            return this.openElements.remove(this.openElements.size() - 1);
        }

        private void handleAttributes(Attributes attributes) {
            if (attributes.getLength() == 1) {
                this.sequence.addToken(this.tokenFactory.newAttribute(attributes.getURI(0), attributes.getLocalName(0), attributes.getQName(0), attributes.getValue(0)));
            } else if (attributes.getLength() > 1) {
                AttributeToken[] attEvents = new AttributeToken[attributes.getLength()];
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attEvents[i] = this.tokenFactory.newAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
                }
                Arrays.sort(attEvents, this.comparator);
                for (AttributeToken attEvent : attEvents) {
                    this.sequence.addToken(attEvent);
                }
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.sequence.addToken(new XMLComment(new String(ch, start, length)));
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void startEntity(String name) {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }
}

