/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PostXMLFixer
extends DiffFilter<XMLToken> {
    private static final XMLToken NIL = new NilToken();
    private final Deque<Operation<StartElementToken>> unclosed = new ArrayDeque<Operation<StartElementToken>>();
    private final Queue<XMLToken> deletions = new ArrayDeque<XMLToken>();
    private final Queue<XMLToken> insertions = new ArrayDeque<XMLToken>();
    private Operator lastOperator = Operator.MATCH;
    private XMLToken lastToken = NIL;
    private boolean hasError = false;

    public PostXMLFixer(DiffHandler<XMLToken> handler) {
        super(handler);
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) throws UncheckedIOException, IllegalStateException {
        if (operator == Operator.DEL) {
            this.deletions.add(token);
        } else if (operator == Operator.INS) {
            this.insertions.add(token);
        } else {
            this.flushChanges();
            if (token.getType() == XMLTokenType.END_ELEMENT && !this.matchStart(Operator.MATCH, (EndElementToken)token)) {
                this.sendMatchingEndElement();
            } else {
                this.send(operator, token);
            }
        }
    }

    private void flushChanges() {
        while (!this.insertions.isEmpty() || !this.deletions.isEmpty()) {
            if (this.lastToken.getType() == XMLTokenType.START_ELEMENT || this.lastToken.getType() == XMLTokenType.ATTRIBUTE) {
                while (PostXMLFixer.isAttribute(this.deletions.peek())) {
                    this.send(Operator.DEL, this.deletions.remove());
                }
                while (PostXMLFixer.isAttribute(this.insertions.peek())) {
                    this.send(Operator.INS, this.insertions.remove());
                }
            }
            XMLToken nextInsertion = this.insertions.peek();
            XMLToken nextDeletion = this.deletions.peek();
            if (PostXMLFixer.isEndElement(nextDeletion) && this.matchStart(Operator.DEL, (EndElementToken)nextDeletion)) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (PostXMLFixer.isEndElement(nextInsertion) && this.matchStart(Operator.INS, (EndElementToken)nextInsertion)) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (PostXMLFixer.isEndElement(nextDeletion)) {
                this.hasError = true;
                this.sendMatchingEndElement();
                this.deletions.remove();
                continue;
            }
            if (PostXMLFixer.isEndElement(nextInsertion)) {
                this.hasError = true;
                this.sendMatchingEndElement();
                this.insertions.remove();
                continue;
            }
            if (this.lastOperator == Operator.DEL && nextDeletion != null) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (this.lastOperator == Operator.INS && nextInsertion != null) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (nextDeletion != null) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (nextInsertion == null) continue;
            this.send(Operator.INS, this.insertions.remove());
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    private static boolean isEndElement(XMLToken token) {
        return token != null && token.getType() == XMLTokenType.END_ELEMENT;
    }

    private static boolean isAttribute(XMLToken token) {
        return token != null && token.getType() == XMLTokenType.ATTRIBUTE;
    }

    private boolean matchStart(Operator operator, EndElementToken token) {
        Operation<StartElementToken> op = this.unclosed.peek();
        if (op == null) {
            return false;
        }
        return op.operator() == operator && token.match(op.token());
    }

    private void sendMatchingEndElement() {
        Operation<StartElementToken> lastStart = this.unclosed.peek();
        if (lastStart != null) {
            EndElementToken end = this.toEndElementToken(lastStart.token());
            this.send(lastStart.operator(), end);
        }
    }

    private EndElementToken toEndElementToken(StartElementToken token) {
        return new XMLEndElement(token);
    }

    private void send(Operator operator, XMLToken token) {
        this.target.handle(operator, token);
        this.lastOperator = operator;
        this.lastToken = token;
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            this.unclosed.push(new Operation<StartElementToken>(operator, (StartElementToken)token));
        } else if (token.getType() == XMLTokenType.END_ELEMENT) {
            this.unclosed.pop();
        }
    }

    @Override
    public void end() {
        this.flushChanges();
        this.sendMatchingEndElement();
    }

    private static class NilToken
    implements XMLToken {
        private NilToken() {
        }

        @Override
        @NotNull
        public XMLTokenType getType() {
            return XMLTokenType.OTHER;
        }

        @Override
        public boolean equals(XMLToken token) {
            return token == this;
        }

        public void toXML(@NotNull XMLWriter xml) {
        }

        @Override
        public void toXML(@NotNull XMLStreamWriter xml) {
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public String getValue() {
            return null;
        }
    }
}

