/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutputBase;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;

public class XMLDiffReporter
extends XMLDiffOutputBase
implements XMLDiffOutput {
    private final XMLWriter xml;

    public XMLDiffReporter(Writer out) {
        this.xml = new XMLWriterNSImpl(out);
    }

    @Override
    public void start() {
        try {
            if (this.includeXMLDeclaration) {
                this.xml.xmlDecl();
            }
            this.xml.openElement("diff-report", true);
            for (Namespace namespace : this.namespaces) {
                if (!Namespace.isDeclarable(namespace)) continue;
                this.xml.openElement("namespace");
                this.xml.attribute("uri", namespace.getUri());
                this.xml.attribute("prefix", namespace.getPrefix());
                this.xml.openElement("namespace");
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void end() {
        try {
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) throws UncheckedIOException, IllegalStateException {
        try {
            this.xml.openElement(XMLDiffReporter.toElementName(operator));
            this.xml.attribute("type", token.getType().toString());
            if (!token.getName().isEmpty()) {
                this.xml.attribute("name", token.getName());
                this.xml.attribute("namespace-uri", token.getNamespaceURI());
            }
            if (token.getType() == XMLTokenType.ATTRIBUTE) {
                this.xml.attribute("value", token.getValue());
            }
            this.xml.attribute("class-name", token.getClass().getSimpleName());
            if (token.getType() == XMLTokenType.TEXT) {
                this.xml.writeText(((TextToken)token).getCharacters());
            }
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String toElementName(Operator operator) {
        assert (operator != null);
        switch (operator) {
            case DEL: {
                return "delete";
            }
            case INS: {
                return "insert";
            }
            case MATCH: {
                return "match";
            }
        }
        return "other";
    }
}

