/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutputBase;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.SpaceToken;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;

public final class DefaultXMLDiffOutput
extends XMLDiffOutputBase
implements XMLDiffOutput {
    final XMLWriterNSImpl xml;
    private int level = 0;

    public DefaultXMLDiffOutput() {
        this(new PrintWriter(System.out));
    }

    public DefaultXMLDiffOutput(Writer w) {
        this.xml = new XMLWriterNSImpl(w, false);
    }

    @Override
    public void start() {
        try {
            if (this.includeXMLDeclaration) {
                this.xml.xmlDecl();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void handle(@NotNull Operator operator, XMLToken token) throws UncheckedIOException, IllegalStateException {
        if (this.level == 0) {
            this.declareNamespaces();
        }
        try {
            if (operator.isEdit()) {
                this.handleEdit(operator, token);
            } else {
                this.handleMatch(token);
            }
            if (token.getType() == XMLTokenType.START_ELEMENT) {
                ++this.level;
            } else if (token.getType() == XMLTokenType.END_ELEMENT) {
                --this.level;
            }
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void end() {
        try {
            this.xml.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    void handleMatch(XMLToken token) throws IOException {
        token.toXML((XMLWriter)this.xml);
    }

    void handleEdit(Operator operator, XMLToken token) throws IOException {
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            token.toXML((XMLWriter)this.xml);
            this.xml.attribute(this.getDiffNamespace().getUri(), operator == Operator.INS ? "insert" : "delete", "true");
        } else if (token.getType() == XMLTokenType.ATTRIBUTE) {
            AttributeToken attribute = (AttributeToken)token;
            if (operator == Operator.INS) {
                token.toXML((XMLWriter)this.xml);
                if (this.hasNoPrefix(attribute)) {
                    this.xml.attribute(this.getDiffNamespace(Operator.INS).getUri(), attribute.getName(), "true");
                }
            } else if (this.hasNoPrefix(attribute)) {
                this.xml.attribute(this.getDiffNamespace(Operator.DEL).getUri(), attribute.getName(), attribute.getValue());
            }
        } else if (token == SpaceToken.NEW_LINE) {
            if (operator == Operator.INS) {
                token.toXML((XMLWriter)this.xml);
            }
        } else if (token.getType() == XMLTokenType.TEXT) {
            this.xml.openElement(this.getDiffNamespace().getUri(), DefaultXMLDiffOutput.toElement(operator), false);
            token.toXML((XMLWriter)this.xml);
            this.xml.closeElement();
        } else if (token.getType() == XMLTokenType.END_ELEMENT) {
            token.toXML((XMLWriter)this.xml);
        } else if (operator == Operator.INS) {
            token.toXML((XMLWriter)this.xml);
        }
    }

    private boolean hasNoPrefix(AttributeToken attribute) {
        if (attribute.getName().indexOf(58) != -1) {
            return false;
        }
        String prefix = this.namespaces.getPrefix(attribute.getNamespaceURI());
        return prefix == null || prefix.isEmpty();
    }

    private void declareNamespaces() {
        Namespace diffNamespace = this.getDiffNamespace();
        Namespace insNamespace = this.getDiffNamespace(Operator.INS);
        Namespace delNamespace = this.getDiffNamespace(Operator.DEL);
        this.xml.setPrefixMapping(diffNamespace.getUri(), diffNamespace.getPrefix());
        this.xml.setPrefixMapping(insNamespace.getUri(), insNamespace.getPrefix());
        this.xml.setPrefixMapping(delNamespace.getUri(), delNamespace.getPrefix());
        if (this.namespaces != null) {
            for (Namespace namespace : this.namespaces) {
                this.xml.setPrefixMapping(namespace.getUri(), namespace.getPrefix());
            }
        }
    }

    private static String toElement(Operator operator) {
        return operator == Operator.INS ? "ins" : "del";
    }
}

