/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;

final class XMLStackMap {
    private Map<Integer, Deque<Operation<StartElementToken>>> previous = new HashMap<Integer, Deque<Operation<StartElementToken>>>();
    private Map<Integer, Deque<Operation<StartElementToken>>> stacks = new HashMap<Integer, Deque<Operation<StartElementToken>>>();

    XMLStackMap() {
    }

    void nextDiff() {
        this.previous = this.stacks;
        this.stacks = new HashMap<Integer, Deque<Operation<StartElementToken>>>(this.previous.size() + 1);
    }

    void initK(int k, boolean down) {
        ArrayDeque<Operation<StartElementToken>> stack = new ArrayDeque<Operation<StartElementToken>>();
        Deque<Operation<StartElementToken>> prev = this.previous.get(down ? k + 1 : k - 1);
        if (prev != null) {
            stack.addAll(prev);
        }
        this.stacks.put(k, stack);
    }

    Deque<Operation<StartElementToken>> getStack(int k) {
        return this.stacks.get(k);
    }

    void update(int k, Operator operator, XMLToken token) {
        Deque<Operation<StartElementToken>> stack = this.getStack(k);
        if (token instanceof StartElementToken) {
            stack.push(new Operation<StartElementToken>(operator, (StartElementToken)token));
        }
        if (token instanceof EndElementToken) {
            stack.pop();
        }
    }

    boolean isAllowed(int k, Operator operator, XMLToken token) {
        if (token instanceof EndElementToken) {
            Deque<Operation<StartElementToken>> stack = this.getStack(k);
            Operation<StartElementToken> last = stack.peek();
            return last != null && last.operator() == operator && ((EndElementToken)token).match(last.token());
        }
        return true;
    }

    public String toString() {
        return "S=" + this.stacks;
    }
}

