/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.Point;

public final class Snake {
    private final Point start;
    private final int length;

    public Snake(@NotNull Point start, int length) {
        this.start = start;
        this.length = length;
    }

    public Point getStart() {
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public Point getEnd() {
        return this.start.plus(this.length, this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snake snake = (Snake)o;
        if (this.length != snake.length) {
            return false;
        }
        return this.start.equals(snake.start);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    public Snake flip() {
        return new Snake(this.getEnd(), -this.length);
    }

    public String toString() {
        return "Snake{start=" + this.start + ", length=" + this.length + '}';
    }
}

