/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.EdgeSnake;
import org.pageseeder.diffx.algorithm.MyersAlgorithm;
import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.algorithm.Vector;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;

public final class MyersLinearAlgorithm<T>
extends MyersAlgorithm<T>
implements DiffAlgorithm<T> {
    @Override
    public void diff(@NotNull List<? extends T> from, @NotNull List<? extends T> to, @NotNull DiffHandler<T> handler) {
        Instance<T> instance = new Instance<T>(from, to);
        List<EdgeSnake> snakes = instance.computePath();
        this.handleResults(from, to, handler, snakes);
    }

    private static class MiddleSnake {
        private final int diff;
        private final EdgeSnake snake;

        public MiddleSnake(int diff, @NotNull EdgeSnake snake) {
            this.diff = diff;
            this.snake = snake;
        }

        public int getDiff() {
            return this.diff;
        }

        public boolean isForward() {
            return this.snake.isForward();
        }

        public EdgeSnake snake() {
            return this.snake;
        }
    }

    static class Instance<T> {
        private final List<? extends T> a;
        private final List<? extends T> b;

        Instance(List<? extends T> a, List<? extends T> b) {
            this.a = a;
            this.b = b;
        }

        public List<EdgeSnake> computePath() {
            Vector VForward = Vector.createLinear(this.a.size(), this.b.size(), true);
            Vector VReverse = Vector.createLinear(this.a.size(), this.b.size(), false);
            ArrayList<EdgeSnake> snakes = new ArrayList<EdgeSnake>();
            ArrayList<Vector> forwardVs = new ArrayList<Vector>();
            ArrayList<Vector> reverseVs = new ArrayList<Vector>();
            this.computePath(0, snakes, forwardVs, reverseVs, 0, this.a.size(), 0, this.b.size(), VForward, VReverse);
            return snakes;
        }

        private void computePath(int recursion, List<EdgeSnake> snakes, List<Vector> forwardVs, List<Vector> reverseVs, int startA, int sizeA, int startB, int sizeB, Vector VForward, Vector VReverse) {
            if (sizeB == 0 && sizeA > 0) {
                EdgeSnake right = EdgeSnake.create(startA, sizeA, startB, sizeB, EdgeSnake.Direction.RIGHT, startA, startB, sizeA, 0);
                if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(right)) {
                    snakes.add(right);
                }
            }
            if (sizeA == 0 && sizeB > 0) {
                EdgeSnake down = EdgeSnake.create(startA, sizeA, startB, sizeB, EdgeSnake.Direction.DOWN, startA, startB, sizeB, 0);
                if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(down)) {
                    snakes.add(down);
                }
            }
            if (sizeA <= 0 || sizeB <= 0) {
                return;
            }
            MiddleSnake middle = this.middleSnake(startA, sizeA, startB, sizeB, VForward, VReverse, forwardVs, reverseVs);
            if (middle.getDiff() > 1) {
                Point xy = middle.isForward() ? middle.snake().getStartPoint() : middle.snake().getEndPoint();
                this.computePath(recursion + 1, snakes, null, null, startA, xy.x() - startA, startB, xy.y() - startB, VForward, VReverse);
                if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(middle.snake())) {
                    snakes.add(middle.snake());
                }
                Point uv = !middle.isForward() ? middle.snake().getStartPoint() : middle.snake().getEndPoint();
                this.computePath(recursion + 1, snakes, null, null, uv.x(), startA + sizeA - uv.x(), uv.y(), startB + sizeB - uv.y(), VForward, VReverse);
            } else if (middle.isForward()) {
                if (middle.snake().x > startA) {
                    if (middle.snake().x - startA != middle.snake().y - startB) {
                        throw new IllegalStateException("Missed D0 forward");
                    }
                    EdgeSnake snake = EdgeSnake.create(startA, sizeA, startB, sizeB, EdgeSnake.Direction.DOWN, startA, startB, 0, middle.snake().x - startA);
                    if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(snake)) {
                        snakes.add(snake);
                    }
                }
                if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(middle.snake())) {
                    snakes.add(middle.snake());
                }
            } else {
                if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(middle.snake())) {
                    snakes.add(middle.snake());
                }
                if (middle.snake().x < startA + sizeA) {
                    if (startA + sizeA - middle.snake().x != startB + sizeB - middle.snake().y) {
                        throw new IllegalStateException("Missed D0 reverse");
                    }
                    EdgeSnake snake = EdgeSnake.create(startA, sizeA, startB, sizeB, EdgeSnake.Direction.DOWN, middle.snake().x, middle.snake().y, 0, startA + sizeA - middle.snake().x);
                    if (snakes.size() == 0 || !snakes.get(snakes.size() - 1).append(snake)) {
                        snakes.add(snake);
                    }
                }
            }
        }

        private MiddleSnake middleSnake(int startA, int sizeA, int startB, int sizeB, Vector VForward, Vector VReverse, List<Vector> forwardVs, List<Vector> reverseVs) {
            int max = (sizeA + sizeB + 1) / 2;
            int delta = sizeA - sizeB;
            VForward.init(sizeA, sizeB);
            VReverse.init(sizeA, sizeB);
            boolean deltaIsEven = delta % 2 == 0;
            for (int d = 0; d <= max; ++d) {
                int matching;
                int yEnd;
                int xEnd;
                int yStart;
                int xStart;
                int k;
                for (k = -d; k <= d; k += 2) {
                    boolean down = k == -d || k != d && VForward.getX(k - 1) < VForward.getX(k + 1);
                    xStart = down ? VForward.getX(k + 1) : VForward.getX(k - 1);
                    yStart = xStart - (down ? k + 1 : k - 1);
                    xEnd = down ? xStart : xStart + 1;
                    yEnd = xEnd - k;
                    matching = 0;
                    while (xEnd < sizeA && yEnd < sizeB && this.a.get(xEnd + startA).equals(this.b.get(yEnd + startB))) {
                        ++xEnd;
                        ++yEnd;
                        ++matching;
                    }
                    VForward.setX(k, xEnd);
                    if (deltaIsEven || k < delta - (d - 1) || k > delta + (d - 1) || VForward.getX(k) < VReverse.getX(k)) continue;
                    EdgeSnake forward = EdgeSnake.create(startA, sizeA, startB, sizeB, down ? EdgeSnake.Direction.DOWN : EdgeSnake.Direction.RIGHT, xStart + startA, yStart + startB, 1, matching);
                    forward.setDiff(d);
                    return new MiddleSnake(2 * d - 1, forward);
                }
                if (forwardVs != null) {
                    forwardVs.add(VForward.snapshot(d, true, 0));
                }
                for (k = -d + delta; k <= d + delta; k += 2) {
                    boolean up = k == d + delta || k != -d + delta && VReverse.getX(k - 1) < VReverse.getX(k + 1);
                    xStart = up ? VReverse.getX(k - 1) : VReverse.getX(k + 1);
                    yStart = xStart - (up ? k - 1 : k + 1);
                    xEnd = up ? xStart : xStart - 1;
                    yEnd = xEnd - k;
                    matching = 0;
                    while (xEnd > 0 && yEnd > 0 && this.a.get(xEnd + startA - 1).equals(this.b.get(yEnd + startB - 1))) {
                        --xEnd;
                        --yEnd;
                        ++matching;
                    }
                    VReverse.setX(k, xEnd);
                    if (!deltaIsEven || k < -d || k > d || VReverse.getX(k) > VForward.getX(k)) continue;
                    EdgeSnake reverse = EdgeSnake.create(startA, sizeA, startB, sizeB, up ? EdgeSnake.Direction.UP : EdgeSnake.Direction.LEFT, xStart + startA, yStart + startB, 1, matching);
                    reverse.setDiff(d);
                    return new MiddleSnake(2 * d, reverse);
                }
                if (reverseVs == null) continue;
                reverseVs.add(VReverse.snapshot(d, false, delta));
            }
            throw new IllegalStateException("Unable to find a middle snake");
        }
    }
}

