/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.algorithm.Vector;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

public final class MyersGreedyAlgorithm2<T>
implements DiffAlgorithm<T> {
    @Override
    public void diff(@NotNull List<? extends T> from, @NotNull List<? extends T> to, @NotNull DiffHandler<T> handler) {
        Instance<? extends T> instance = new Instance<T>(from, to);
        ((Instance)instance).diff(handler);
    }

    private static class Instance<T> {
        private final List<? extends T> a;
        private final List<? extends T> b;
        private final int sizeA;
        private final int sizeB;

        Instance(List<? extends T> a, List<? extends T> b) {
            this.a = a;
            this.b = b;
            this.sizeA = a.size();
            this.sizeB = b.size();
        }

        private void diff(DiffHandler<T> handler) {
            int max = this.sizeA + this.sizeB;
            int delta = this.sizeA - this.sizeB;
            Vector vector = Vector.create(this.sizeA, this.sizeB, false, max);
            ArrayList<Vector> vectors = new ArrayList<Vector>();
            int diff = -1;
            for (int d = 0; d <= max; ++d) {
                diff = this.reverse(vector, d);
                vectors.add(vector.snapshot(d, false, delta));
                if (diff >= 0) break;
            }
            if (diff < 0) {
                throw new IllegalStateException("Unable to find a solution!");
            }
            this.solve(vectors, handler);
        }

        private int reverse(Vector vector, int d) {
            int delta = this.sizeA - this.sizeB;
            for (int k = -d + delta; k <= d + delta; k += 2) {
                int y;
                boolean up = k == d + delta || k != -d + delta && vector.getX(k - 1) < vector.getX(k + 1);
                int x = up ? vector.getX(k - 1) : vector.getX(k + 1) - 1;
                for (y = x - k; x > 0 && y > 0 && this.a.get(x - 1).equals(this.b.get(y - 1)); --x, --y) {
                }
                vector.setX(k, x);
                if (x > 0 || y > 0) continue;
                return d;
            }
            return -1;
        }

        private void solve(@NotNull List<Vector> vectors, DiffHandler<T> handler) {
            Point target = new Point(0, 0);
            int delta = this.sizeA - this.sizeB;
            int x = 0;
            int y = 0;
            int d = vectors.size() - 1;
            while (target.x() < this.sizeA || target.y() > this.sizeB) {
                int startY;
                int k;
                Vector vector = vectors.get(d);
                int startX = vector.getX(k = target.x() - target.y());
                if (!target.isSame(startX, startY = startX - k)) {
                    throw new IllegalStateException("No solution for d:" + d + " k:" + k + " p:" + target + " V:( " + startX + ", " + startY + " )");
                }
                boolean up = k == d + delta || k != -d + delta && vector.getX(k - 1) < vector.getX(k + 1);
                int endX = up ? vector.getX(k - 1) : vector.getX(k + 1);
                int endY = endX - (up ? k - 1 : k + 1);
                int matching = Math.min(endX - startX, endY - startY);
                for (int i = 0; i < matching; ++i) {
                    handler.handle(Operator.MATCH, this.a.get(x));
                    ++x;
                    ++y;
                }
                while (x < endX && x < this.sizeA) {
                    handler.handle(Operator.DEL, this.a.get(x));
                    ++x;
                }
                while (y < endY && y < this.sizeB) {
                    handler.handle(Operator.INS, this.b.get(y));
                    ++y;
                }
                target = new Point(endX, Math.min(endY, this.sizeB));
                --d;
            }
            while (x < this.sizeA) {
                handler.handle(Operator.DEL, this.a.get(x));
                ++x;
            }
            while (y < this.sizeB) {
                handler.handle(Operator.INS, this.b.get(y));
                ++y;
            }
        }
    }
}

