/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;

public final class ElementStackFilter
extends DiffFilter<XMLToken> {
    private final Deque<Operation<StartElementToken>> elements = new ArrayDeque<Operation<StartElementToken>>(16);

    public ElementStackFilter(DiffHandler<XMLToken> target) {
        super(target);
    }

    public int depth() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Operation<StartElementToken> current() {
        return this.elements.peek();
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) {
        this.target.handle(operator, token);
        if (token instanceof StartElementToken) {
            this.elements.push(new Operation<StartElementToken>(operator, (StartElementToken)token));
        } else if (token instanceof EndElementToken) {
            this.elements.pop();
        }
    }

    public boolean isAllowed(Operator operator, XMLToken token) {
        if (!(token instanceof EndElementToken)) {
            return true;
        }
        StartElementToken start = ((EndElementToken)token).getOpenElement();
        return this.matchCurrent(operator, start);
    }

    public boolean matchCurrent(Operator operator, StartElementToken start) {
        Operation<StartElementToken> current = this.current();
        if (current == null) {
            return false;
        }
        return operator == current.operator() && start.equals(current.token());
    }

    public boolean hasPriorityOver(XMLToken token1, XMLToken token2) {
        return token1 instanceof AttributeToken && !(token2 instanceof AttributeToken) && !this.isEmpty();
    }

    public void clear() {
        this.elements.clear();
    }
}

