/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pageseeder.diffx.api.Operator;

public final class Action<T> {
    private final Operator operator;
    private final List<T> tokens;

    public Action(Operator operator) {
        this(operator, new ArrayList());
    }

    public Action(Operator operator, List<T> tokens) {
        this.operator = Objects.requireNonNull(operator);
        this.tokens = Objects.requireNonNull(tokens);
    }

    public void add(T token) {
        this.tokens.add(token);
    }

    public List<T> tokens() {
        return this.tokens;
    }

    public Operator operator() {
        return this.operator;
    }

    public Action<T> flip() {
        return this.operator == Operator.MATCH ? this : new Action<T>(this.operator.flip(), this.tokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.operator != action.operator) {
            return false;
        }
        return this.tokens.equals(action.tokens);
    }

    public int hashCode() {
        int result = this.operator.hashCode();
        result = 31 * result + this.tokens.hashCode();
        return result;
    }

    public String toString() {
        return "Action{" + (Object)((Object)this.operator) + "," + this.tokens + '}';
    }
}

