/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;
import org.pageseeder.diffx.core.DefaultXMLProcessor;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.OptimisticXMLProcessor;
import org.pageseeder.diffx.core.TextOnlyProcessor;
import org.pageseeder.diffx.format.CompleteXMLDiffOutput;
import org.pageseeder.diffx.format.DefaultXMLDiffOutput;
import org.pageseeder.diffx.format.StrictXMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.format.XMLDiffReporter;
import org.pageseeder.diffx.load.DOMLoader;
import org.pageseeder.diffx.load.SAXLoader;
import org.pageseeder.diffx.load.XMLEventLoader;
import org.pageseeder.diffx.load.XMLLoader;
import org.pageseeder.diffx.load.XMLStreamLoader;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.util.CommandLine;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.diffx.xml.Sequence;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class Main {
    private Main() {
    }

    public static boolean equivalent(File xmlA, File xmlB) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(xmlA);
        Sequence seq1 = loader.load(xmlB);
        return seq0.equals(seq1);
    }

    public static boolean equivalent(InputStream xmlA, InputStream xmlB) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(new InputSource(xmlA));
        Sequence seq1 = loader.load(new InputSource(xmlB));
        return seq0.equals(seq1);
    }

    public static boolean equivalent(Reader xmlA, Reader xmlB) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq0 = loader.load(new InputSource(xmlA));
        Sequence seq1 = loader.load(new InputSource(xmlB));
        return seq0.equals(seq1);
    }

    public static void diff(Node xmlA, Node xmlB, Writer out, DiffConfig config) throws DiffException, IOException {
        DOMLoader loader = new DOMLoader();
        if (config != null) {
            loader.setConfig(config);
        }
        Sequence seq1 = loader.load(xmlA);
        Sequence seq2 = loader.load(xmlB);
        Main.diff(seq1, seq2, out);
    }

    public static void diff(NodeList xmlA, NodeList xmlB, Writer out, DiffConfig config) throws DiffException, IOException {
        DOMLoader loader = new DOMLoader();
        if (config != null) {
            loader.setConfig(config);
        }
        Sequence seq1 = loader.load(xmlA);
        Sequence seq2 = loader.load(xmlB);
        Main.diff(seq1, seq2, out);
    }

    public static void diff(Reader xmlA, Reader xmlB, Writer out, DiffConfig config) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        if (config != null) {
            loader.setConfig(config);
        }
        Sequence seq1 = loader.load(new InputSource(xmlA));
        Sequence seq2 = loader.load(new InputSource(xmlB));
        Main.diff(seq1, seq2, out);
    }

    public static void diff(Reader xmlA, Reader xmlB, Writer out) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq1 = loader.load(new InputSource(xmlA));
        Sequence seq2 = loader.load(new InputSource(xmlB));
        Main.diff(seq1, seq2, out);
    }

    public static void diff(InputStream xmlA, InputStream xmlB, OutputStream out) throws DiffException, IOException {
        SAXLoader loader = new SAXLoader();
        Sequence seq1 = loader.load(new InputSource(xmlA));
        Sequence seq2 = loader.load(new InputSource(xmlB));
        Main.diff(seq1, seq2, (Writer)new OutputStreamWriter(out));
    }

    private static void diff(Sequence seq1, Sequence seq2, Writer out) {
        DefaultXMLDiffOutput output = new DefaultXMLDiffOutput(out);
        NamespaceSet namespaces = NamespaceSet.merge(seq1.getNamespaces(), seq2.getNamespaces());
        output.setNamespaces(namespaces);
        DefaultXMLProcessor processor = new DefaultXMLProcessor();
        processor.diff((List<? extends XMLToken>)seq1.tokens(), (List<? extends XMLToken>)seq2.tokens(), output);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            Main.usage();
            return;
        }
        try {
            DiffProcessor<XMLToken> processor;
            OutputStreamWriter out;
            XMLDiffOutput output;
            boolean profile = CommandLine.hasSwitch("-profile", args);
            boolean quiet = CommandLine.hasSwitch("-quiet", args);
            File xmlA = new File(args[args.length - 2]);
            File xmlB = new File(args[args.length - 1]);
            long t0 = System.currentTimeMillis();
            XMLLoader loader = Main.getLoader(args);
            if (loader == null) {
                return;
            }
            Sequence seq1 = loader.load(xmlA);
            Sequence seq2 = loader.load(xmlB);
            long t1 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Loaded files in " + (t1 - t0) + "ms");
            }
            DiffConfig config = DiffConfig.getDefault().granularity(Main.getTextGranularity(args)).whitespace(Main.getWhiteSpaceProcessing(args));
            if (!quiet) {
                System.err.println("Whitespace processing: " + (Object)((Object)config.granularity()) + " " + (Object)((Object)config.whitespace()));
            }
            if ((output = Main.getOutputFormat(args, out = new OutputStreamWriter(Main.getOutput(args), StandardCharsets.UTF_8))) == null) {
                return;
            }
            NamespaceSet namespaces = NamespaceSet.merge(seq1.getNamespaces(), seq2.getNamespaces());
            output.setNamespaces(namespaces);
            if (!quiet) {
                System.err.println("Matrix: " + seq1.size() + "x" + seq2.size());
            }
            if ((processor = Main.getProcessor(args)) == null) {
                return;
            }
            processor.diff(seq1.tokens(), seq2.tokens(), output);
            long t2 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Executed algorithm files in " + (t2 - t1) + "ms");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Compare the SAX events returned by two XML files.");
        System.err.println("usage:");
        System.err.println("  Main [options] xml_file1 xml_file2");
        System.err.println("where:");
        System.err.println("  xml_file1 = Path to the new XML file");
        System.err.println("  xml_file2 = Path to the old XML file");
        System.err.println("options:");
        System.err.println("  -profile        Display profiling info");
        System.err.println("  -o [output]     The output file");
        System.err.println("  -l [loader]     Choose a specific loader");
        System.err.println("                   sax* | dom | stream | stax | text");
        System.err.println("  -p [processor]  Choose a specific processor");
        System.err.println("                   optimistic* | xml | text");
        System.err.println("  -f [format]     Choose a specific formatter");
        System.err.println("                   default* | complete | strict | report");
        System.err.println("  -w [whitespace] Define whitespace processing");
        System.err.println("                   preserve* | compare | ignore");
        System.err.println("  -g [granul]     Define text diffing granularity");
        System.err.println("                   word* | text | character");
        System.err.println(" * indicates option used by default.");
        System.exit(1);
    }

    private static XMLLoader getLoader(String[] args) {
        String loaderArg = CommandLine.getParameter("-l", args);
        if (loaderArg == null || "sax".equals(loaderArg)) {
            return new SAXLoader();
        }
        if ("dom".equals(loaderArg)) {
            return new DOMLoader();
        }
        if ("stream".equals(loaderArg)) {
            return new XMLStreamLoader();
        }
        if ("stax".equals(loaderArg)) {
            return new XMLEventLoader();
        }
        Main.usage();
        return null;
    }

    private static OutputStream getOutput(String[] args) throws FileNotFoundException {
        String outArg = CommandLine.getParameter("-o", args);
        if (outArg == null) {
            return System.out;
        }
        return new BufferedOutputStream(new FileOutputStream(outArg));
    }

    private static DiffProcessor<XMLToken> getProcessor(String[] args) {
        String loaderArg = CommandLine.getParameter("-p", args);
        if (loaderArg == null || "optimistic".equals(loaderArg)) {
            return new DefaultXMLProcessor();
        }
        if ("xml".equals(loaderArg)) {
            return new OptimisticXMLProcessor();
        }
        if ("text".equals(loaderArg)) {
            return new TextOnlyProcessor<XMLToken>();
        }
        Main.usage();
        return null;
    }

    private static XMLDiffOutput getOutputFormat(String[] args, Writer out) {
        String formatArg = CommandLine.getParameter("-f", args);
        if (formatArg == null || "default".equals(formatArg)) {
            return new DefaultXMLDiffOutput(out);
        }
        if ("complete".equals(formatArg)) {
            return new CompleteXMLDiffOutput(out);
        }
        if ("strict".equals(formatArg)) {
            return new StrictXMLDiffOutput(out);
        }
        if ("report".equals(formatArg)) {
            return new XMLDiffReporter(out);
        }
        Main.usage();
        return null;
    }

    private static WhiteSpaceProcessing getWhiteSpaceProcessing(String[] args) {
        String formatArg = CommandLine.getParameter("-w", args);
        if (formatArg == null || "preserve".equals(formatArg)) {
            return WhiteSpaceProcessing.PRESERVE;
        }
        if ("compare".equals(formatArg)) {
            return WhiteSpaceProcessing.COMPARE;
        }
        if ("ignore".equals(formatArg)) {
            return WhiteSpaceProcessing.IGNORE;
        }
        Main.usage();
        return null;
    }

    private static TextGranularity getTextGranularity(String[] args) {
        String formatArg = CommandLine.getParameter("-g", args);
        if (formatArg == null || "word".equals(formatArg)) {
            return TextGranularity.SPACE_WORD;
        }
        if ("text".equals(formatArg)) {
            return TextGranularity.TEXT;
        }
        if ("character".equals(formatArg)) {
            return TextGranularity.CHARACTER;
        }
        Main.usage();
        return null;
    }
}

